/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.io.IOException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.TryDefinition;

public class TryProcessorMultipleExceptionTest
extends ContextTestSupport {
    public void testIOException() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        this.getMockEndpoint("mock:catch").expectedMessageCount(1);
        this.getMockEndpoint("mock:finally").expectedMessageCount(1);
        this.sendBody("direct:start", "Damn IO");
        this.assertMockEndpointsSatisfied();
    }

    public void testIllegalStateException() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        this.getMockEndpoint("mock:catch").expectedMessageCount(1);
        this.getMockEndpoint("mock:finally").expectedMessageCount(1);
        this.sendBody("direct:start", "Damn State");
        this.assertMockEndpointsSatisfied();
    }

    public void testOk() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.getMockEndpoint("mock:catch").expectedMessageCount(0);
        this.getMockEndpoint("mock:finally").expectedMessageCount(1);
        this.sendBody("direct:start", "Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((TryDefinition)((TryDefinition)((TryDefinition)((TryDefinition)this.from("direct:start").doTry().process((Processor)new ProcessorFail())).to("mock:result")).doCatch(new Class[]{IOException.class, IllegalStateException.class}).to("mock:catch")).doFinally().to("mock:finally")).end();
            }
        };
    }

    public static class ProcessorFail
    implements Processor {
        public void process(Exchange exchange) throws Exception {
            String body = (String)exchange.getIn().getBody(String.class);
            if ("Damn IO".equals(body)) {
                throw new IOException("Damn IO");
            }
            if ("Damn State".equals(body)) {
                throw new IllegalStateException("Damn State");
            }
        }
    }
}

