/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.ValidationException;
import org.apache.camel.builder.Builder;
import org.apache.camel.builder.ProcessorBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.TryDefinition;
import org.apache.camel.processor.MyValidator;

public class ValidationTest
extends ContextTestSupport {
    protected Processor validator = new MyValidator();
    protected MockEndpoint validEndpoint;
    protected MockEndpoint invalidEndpoint;

    public void testValidMessage() throws Exception {
        this.validEndpoint.expectedMessageCount(1);
        this.invalidEndpoint.expectedMessageCount(0);
        Object result = this.template.requestBodyAndHeader("direct:start", (Object)"<valid/>", "foo", (Object)"bar");
        ValidationTest.assertEquals((Object)"validResult", (Object)result);
        this.assertMockEndpointsSatisfied();
    }

    public void testInvalidMessage() throws Exception {
        this.validEndpoint.expectedMessageCount(0);
        this.invalidEndpoint.expectedMessageCount(1);
        try {
            this.template.sendBodyAndHeader("direct:start", (Object)"<invalid/>", "foo", (Object)"notMatchedHeaderValue");
        }
        catch (RuntimeCamelException runtimeCamelException) {
            // empty catch block
        }
        this.assertMockEndpointsSatisfied();
    }

    public void testinvalidThenValidMessage() throws Exception {
        this.validEndpoint.expectedMessageCount(2);
        this.invalidEndpoint.expectedMessageCount(1);
        try {
            this.template.sendBodyAndHeader("direct:start", (Object)"<invalid/>", "foo", (Object)"notMatchedHeaderValue");
        }
        catch (RuntimeCamelException e) {
            // empty catch block
        }
        Object result = this.template.requestBodyAndHeader("direct:start", (Object)"<valid/>", "foo", (Object)"bar");
        ValidationTest.assertEquals((Object)"validResult", (Object)result);
        result = this.template.requestBodyAndHeader("direct:start", (Object)"<valid/>", "foo", (Object)"bar");
        ValidationTest.assertEquals((Object)"validResult", (Object)result);
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.validEndpoint = this.resolveMandatoryEndpoint("mock:valid", MockEndpoint.class);
        this.invalidEndpoint = this.resolveMandatoryEndpoint("mock:invalid", MockEndpoint.class);
        this.validEndpoint.whenAnyExchangeReceived(ProcessorBuilder.setOutBody((Expression)Builder.constant((Object)"validResult")));
        this.invalidEndpoint.whenAnyExchangeReceived(ProcessorBuilder.setOutBody((Expression)Builder.constant((Object)"invalidResult")));
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((TryDefinition)((TryDefinition)this.from("direct:start").doTry().process(ValidationTest.this.validator)).to("mock:valid")).doCatch(ValidationException.class).to("mock:invalid");
            }
        };
    }
}

