/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import junit.framework.TestCase;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.Animal;
import org.apache.camel.processor.AnimalDeepClonePrepare;

public class WireTapOnPrepareTest
extends ContextTestSupport {
    public void testWireTapOnPrepare() throws Exception {
        this.getMockEndpoint("mock:a").expectedMessageCount(1);
        ((ValueBuilder)this.getMockEndpoint("mock:a").message(0).body(String.class)).isEqualTo((Object)"1 Tony the Tiger");
        this.getMockEndpoint("mock:b").expectedMessageCount(1);
        ((ValueBuilder)this.getMockEndpoint("mock:b").message(0).body(String.class)).isEqualTo((Object)"1 Tiger");
        Animal original = new Animal(1, "Tiger");
        this.template.sendBody("direct:start", (Object)original);
        this.assertMockEndpointsSatisfied();
        Animal aAnimal = (Animal)((Exchange)this.getMockEndpoint("mock:a").getExchanges().get(0)).getIn().getBody(Animal.class);
        Animal bAnimal = (Animal)((Exchange)this.getMockEndpoint("mock:b").getExchanges().get(0)).getIn().getBody(Animal.class);
        WireTapOnPrepareTest.assertSame((String)"Original instance should stay in main route", (Object)original, (Object)bAnimal);
        WireTapOnPrepareTest.assertNotSame((String)"Copy should go to Wire Tap Endpoint", (Object)original, (Object)aAnimal);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").wireTap("direct:a").onPrepare((Processor)new AnimalDeepClonePrepare()).to("direct:b");
                ((RouteDefinition)this.from("direct:a").process((Processor)new ProcessorA())).to("mock:a");
                ((ExpressionNode)this.from("direct:b").delay(1000L).process((Processor)new ProcessorB())).to("mock:b");
            }
        };
    }

    public static class ProcessorB
    implements Processor {
        public void process(Exchange exchange) throws Exception {
            Animal body = (Animal)exchange.getIn().getBody(Animal.class);
            TestCase.assertEquals((int)1, (int)body.getId());
            TestCase.assertEquals((String)"Tiger", (String)body.getName());
        }
    }

    public static class ProcessorA
    implements Processor {
        public void process(Exchange exchange) throws Exception {
            Animal body = (Animal)exchange.getIn().getBody(Animal.class);
            TestCase.assertEquals((int)1, (int)body.getId());
            TestCase.assertEquals((String)"Tiger", (String)body.getName());
            body.setName("Tony the Tiger");
        }
    }
}

