/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregator;

import java.util.List;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;

public class AggregateGroupedExchangeTest
extends ContextTestSupport {
    public void testGrouped() throws Exception {
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"100");
        this.template.sendBody("direct:start", (Object)"150");
        this.template.sendBody("direct:start", (Object)"130");
        this.template.sendBody("direct:start", (Object)"200");
        this.template.sendBody("direct:start", (Object)"190");
        this.assertMockEndpointsSatisfied();
        Exchange out = (Exchange)result.getExchanges().get(0);
        List grouped = (List)out.getProperty("CamelGroupedExchange", List.class);
        AggregateGroupedExchangeTest.assertEquals((int)5, (int)grouped.size());
        AggregateGroupedExchangeTest.assertEquals((String)"100", (String)((String)((Exchange)grouped.get(0)).getIn().getBody(String.class)));
        AggregateGroupedExchangeTest.assertEquals((String)"150", (String)((String)((Exchange)grouped.get(1)).getIn().getBody(String.class)));
        AggregateGroupedExchangeTest.assertEquals((String)"130", (String)((String)((Exchange)grouped.get(2)).getIn().getBody(String.class)));
        AggregateGroupedExchangeTest.assertEquals((String)"200", (String)((String)((Exchange)grouped.get(3)).getIn().getBody(String.class)));
        AggregateGroupedExchangeTest.assertEquals((String)"190", (String)((String)((Exchange)grouped.get(4)).getIn().getBody(String.class)));
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").aggregate((Expression)this.constant(true)).completionTimeout(500L).groupExchanges().to("mock:result");
            }
        };
    }
}

