/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregator;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.AggregateDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.aggregate.AggregationStrategy;

public class AggregateLostGroupIssueTest
extends ContextTestSupport {
    private int messageIndex;

    public void testAggregateLostGroupIssue() throws Exception {
        this.messageIndex = 0;
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(2);
        ((ValueBuilder)mock.message(0).body()).isEqualTo((Object)"0,1,2,3,4,5,6,7,8,9");
        ((ValueBuilder)mock.message(1).body()).isEqualTo((Object)"10,11,12,13,14,15,16,17,18,19");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("timer://foo?period=100&delay=1000").startupOrder(2).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        exchange.getOut().setBody((Object)AggregateLostGroupIssueTest.this.messageIndex++);
                        exchange.getOut().setHeader("aggregateGroup", (Object)"group1");
                    }
                })).to("direct:aggregator");
                ((AggregateDefinition)this.from("direct:aggregator").startupOrder(1).aggregate((Expression)this.header("aggregateGroup"), new AggregationStrategy(){

                    public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
                        if (oldExchange == null) {
                            return newExchange;
                        }
                        String oldBody = (String)oldExchange.getIn().getBody(String.class);
                        String newBody = (String)newExchange.getIn().getBody(String.class);
                        oldExchange.getIn().setBody((Object)(oldBody + "," + newBody));
                        return oldExchange;
                    }
                }).completionSize(10).completionTimeout(2000L).to("log:aggregated")).to("mock:result");
            }
        };
    }
}

