/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregator;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.apache.camel.processor.aggregate.UseLatestAggregationStrategy;
import org.apache.camel.processor.aggregator.AggregateTimeoutWithExecutorServiceTest;

public class AggregateTimeoutWithNoExecutorServiceTest
extends ContextTestSupport {
    public void testThreadUsedForEveryAggregatorWhenDefaultExecutorServiceUsed() throws Exception {
        int i;
        AggregateTimeoutWithNoExecutorServiceTest.assertTrue((String)"There should be a thread for every aggregator when using defaults", (AggregateTimeoutWithExecutorServiceTest.aggregateThreadsCount() >= 20 ? 1 : 0) != 0);
        for (i = 0; i < 20; ++i) {
            MockEndpoint result = this.getMockEndpoint("mock:result" + i);
            result.expectedBodiesReceived(new Object[]{"Message 4"});
        }
        for (i = 0; i < 20; ++i) {
            for (int j = 0; j < 5; ++j) {
                this.template.sendBodyAndHeader("direct:start" + i, (Object)("Message " + j), "id", (Object)"1");
            }
        }
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                for (int i = 0; i < 20; ++i) {
                    this.from("direct:start" + i).aggregate((Expression)this.header("id"), (AggregationStrategy)new UseLatestAggregationStrategy()).completionTimeout(3000L).to("mock:result" + i);
                }
            }
        };
    }
}

