/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregator;

import java.util.Map;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.processor.aggregate.AggregationStrategyBeanAdapter;
import org.apache.camel.util.toolbox.AggregationStrategies;

public class AggregationStrategyBeanAdapterWithHeadersTest
extends ContextTestSupport {
    private MyBodyAppender appender = new MyBodyAppender();
    private AggregationStrategyBeanAdapter myStrategy;

    public void testAggregate() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"ABC"});
        this.getMockEndpoint("mock:result").expectedHeaderReceived("count", (Object)6);
        this.template.sendBodyAndHeader("direct:start", (Object)"A", "count", (Object)1);
        this.template.sendBodyAndHeader("direct:start", (Object)"B", "count", (Object)2);
        this.template.sendBodyAndHeader("direct:start", (Object)"C", "count", (Object)3);
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").aggregate((Expression)this.constant(true), AggregationStrategies.bean((Object)AggregationStrategyBeanAdapterWithHeadersTest.this.appender, (String)"appendWithHeaders")).completionSize(3).to("mock:result");
            }
        };
    }

    public static final class MyBodyAppender {
        public String appendWithHeaders(String existing, Map oldHeaders, String next, Map newHeaders) {
            if (next != null) {
                Integer count = (Integer)oldHeaders.get("count") + (Integer)newHeaders.get("count");
                oldHeaders.put("count", count);
                return existing + next;
            }
            return existing;
        }
    }
}

