/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregator;

import junit.framework.TestCase;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.aggregate.AggregationStrategy;

public class EnricherRouteNumberOfProcessorTest
extends ContextTestSupport {
    private static volatile boolean failed;

    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    public void testOneProcesssor() throws Exception {
        failed = false;
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)((RouteDefinition)this.from("direct:start").enrich("direct:enrich", new AggregationStrategy(){

                    public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
                        if (oldExchange == null) {
                            return newExchange;
                        }
                        String body = (String)newExchange.getIn().getBody(String.class);
                        TestCase.assertNotNull((Object)body);
                        return newExchange;
                    }
                })).to("mock:foo")).end().to("mock:result");
                this.from("direct:enrich").process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        TestCase.assertFalse((String)"Should not have out", (boolean)failed);
                        String s = (String)exchange.getIn().getBody(String.class);
                        exchange.getIn().setBody((Object)("Hi " + s));
                    }
                });
            }
        });
        this.context.start();
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedMessageCount(1);
        this.getMockEndpoint("mock:foo").expectedBodiesReceived(new Object[]{"Hi Claus"});
        this.getMockEndpoint("mock:foo").expectedHeaderReceived("id", (Object)1);
        this.template.requestBodyAndHeader("direct:start", (Object)"Claus", "id", (Object)1);
        this.assertMockEndpointsSatisfied();
    }

    public void testThreeProcesssors() throws Exception {
        failed = false;
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)((RouteDefinition)this.from("direct:start").enrich("direct:enrich", new AggregationStrategy(){

                    public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
                        if (oldExchange == null) {
                            return newExchange;
                        }
                        String body = (String)newExchange.getIn().getBody(String.class);
                        TestCase.assertNotNull((Object)body);
                        return newExchange;
                    }
                })).to("mock:foo")).end().to("mock:result");
                ((RouteDefinition)((RouteDefinition)this.from("direct:enrich").pipeline(new String[]{"log:a", "log:b"})).to("log:foo")).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        TestCase.assertFalse((String)"Should not have out", (boolean)failed);
                        String s = (String)exchange.getIn().getBody(String.class);
                        exchange.getIn().setBody((Object)("Hi " + s));
                    }
                });
            }
        });
        this.context.start();
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedMessageCount(1);
        this.getMockEndpoint("mock:foo").expectedBodiesReceived(new Object[]{"Hi Claus"});
        this.getMockEndpoint("mock:foo").expectedHeaderReceived("id", (Object)1);
        this.template.requestBodyAndHeader("direct:start", (Object)"Claus", "id", (Object)1);
        this.assertMockEndpointsSatisfied();
    }
}

