/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregator;

import junit.framework.TestCase;
import org.apache.camel.processor.aggregate.OptimisticLockRetryPolicy;

public class OptimisticLockRetryPolicyTest
extends TestCase {
    private static long precision = 5L;

    public void testRandomBackOff() throws Exception {
        OptimisticLockRetryPolicy policy = new OptimisticLockRetryPolicy();
        policy.setRandomBackOff(true);
        policy.setExponentialBackOff(false);
        policy.setMaximumRetryDelay(500L);
        for (int i = 0; i < 10; ++i) {
            long start = System.currentTimeMillis();
            policy.doDelay(i);
            long elapsed = System.currentTimeMillis() - start;
            OptimisticLockRetryPolicyTest.assertTrue((elapsed <= policy.getMaximumRetryDelay() + precision && elapsed >= 0L ? 1 : 0) != 0);
        }
    }

    public void testExponentialBackOff() throws Exception {
        OptimisticLockRetryPolicy policy = new OptimisticLockRetryPolicy();
        policy.setRandomBackOff(false);
        policy.setExponentialBackOff(true);
        policy.setMaximumRetryDelay(0L);
        policy.setRetryDelay(50L);
        for (int i = 0; i < 10; ++i) {
            long start = System.currentTimeMillis();
            policy.doDelay(i);
            long elapsed = System.currentTimeMillis() - start;
            OptimisticLockRetryPolicyTest.assertTrue((elapsed >= (policy.getRetryDelay() << i) - precision ? 1 : 0) != 0);
            OptimisticLockRetryPolicyTest.assertTrue((elapsed <= (policy.getRetryDelay() << i) + precision ? 1 : 0) != 0);
        }
    }

    public void testExponentialBackOffMaximumRetryDelay() throws Exception {
        OptimisticLockRetryPolicy policy = new OptimisticLockRetryPolicy();
        policy.setRandomBackOff(false);
        policy.setExponentialBackOff(true);
        policy.setMaximumRetryDelay(200L);
        policy.setRetryDelay(50L);
        block4: for (int i = 0; i < 10; ++i) {
            long start = System.currentTimeMillis();
            policy.doDelay(i);
            long elapsed = System.currentTimeMillis() - start;
            switch (i) {
                case 0: {
                    OptimisticLockRetryPolicyTest.assertTrue((elapsed <= 50L + precision ? 1 : 0) != 0);
                    OptimisticLockRetryPolicyTest.assertTrue((elapsed >= 50L - precision ? 1 : 0) != 0);
                    continue block4;
                }
                case 1: {
                    OptimisticLockRetryPolicyTest.assertTrue((elapsed <= 100L + precision ? 1 : 0) != 0);
                    OptimisticLockRetryPolicyTest.assertTrue((elapsed >= 100L - precision ? 1 : 0) != 0);
                    continue block4;
                }
                default: {
                    OptimisticLockRetryPolicyTest.assertTrue((elapsed <= 200L + precision ? 1 : 0) != 0);
                    OptimisticLockRetryPolicyTest.assertTrue((elapsed >= 200L - precision ? 1 : 0) != 0);
                }
            }
        }
    }

    public void testRetryDelay() throws Exception {
        OptimisticLockRetryPolicy policy = new OptimisticLockRetryPolicy();
        policy.setRandomBackOff(false);
        policy.setExponentialBackOff(false);
        policy.setMaximumRetryDelay(0L);
        policy.setRetryDelay(50L);
        for (int i = 0; i < 10; ++i) {
            long start = System.currentTimeMillis();
            policy.doDelay(i);
            long elapsed = System.currentTimeMillis() - start;
            OptimisticLockRetryPolicyTest.assertTrue((elapsed <= policy.getRetryDelay() + precision ? 1 : 0) != 0);
            OptimisticLockRetryPolicyTest.assertTrue((elapsed >= policy.getRetryDelay() - precision ? 1 : 0) != 0);
        }
    }

    public void testMaximumRetries() throws Exception {
        OptimisticLockRetryPolicy policy = new OptimisticLockRetryPolicy();
        policy.setRandomBackOff(false);
        policy.setExponentialBackOff(false);
        policy.setMaximumRetryDelay(0L);
        policy.setMaximumRetries(2);
        policy.setRetryDelay(50L);
        block3: for (int i = 0; i < 10; ++i) {
            switch (i) {
                case 0: 
                case 1: {
                    OptimisticLockRetryPolicyTest.assertTrue((boolean)policy.shouldRetry(i));
                    continue block3;
                }
                default: {
                    OptimisticLockRetryPolicyTest.assertFalse((boolean)policy.shouldRetry(i));
                }
            }
        }
    }
}

