/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.async;

import org.apache.camel.CamelExecutionException;
import org.apache.camel.Component;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.async.MyAsyncComponent;

public class AsyncEndpointFailedAfterTest
extends ContextTestSupport {
    private static String beforeThreadName;
    private static String afterThreadName;

    public void testAsyncEndpoint() throws Exception {
        this.getMockEndpoint("mock:before").expectedBodiesReceived(new Object[]{"Hello Camel"});
        this.getMockEndpoint("mock:after").expectedBodiesReceived(new Object[]{"Bye Camel"});
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        try {
            this.template.requestBody("direct:start", (Object)"Hello Camel", String.class);
            AsyncEndpointFailedAfterTest.fail((String)"Should have thrown an exception");
        }
        catch (CamelExecutionException e) {
            AsyncEndpointFailedAfterTest.assertIsInstanceOf(IllegalArgumentException.class, e.getCause());
            AsyncEndpointFailedAfterTest.assertEquals((String)"Damn", (String)e.getCause().getMessage());
        }
        this.assertMockEndpointsSatisfied();
        AsyncEndpointFailedAfterTest.assertFalse((String)"Should use different threads", (boolean)beforeThreadName.equalsIgnoreCase(afterThreadName));
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                AsyncEndpointFailedAfterTest.this.context.addComponent("async", (Component)new MyAsyncComponent());
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:start").to("mock:before")).to("log:before")).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        beforeThreadName = Thread.currentThread().getName();
                    }
                })).to("async:bye:camel")).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        afterThreadName = Thread.currentThread().getName();
                    }
                })).to("log:after")).to("mock:after")).throwException((Exception)new IllegalArgumentException("Damn"))).to("mock:result");
            }
        };
    }
}

