/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.enricher;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.apache.camel.processor.enricher.FailureProcessor;
import org.apache.camel.processor.enricher.SampleAggregator;

public class EnricherTest
extends ContextTestSupport {
    private static SampleAggregator aggregationStrategy = new SampleAggregator();
    protected MockEndpoint mock;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.mock = this.getMockEndpoint("mock:mock");
    }

    public void testEnrichInOnly() throws InterruptedException {
        this.mock.expectedBodiesReceived(new Object[]{"test:blah"});
        ((ValueBuilder)this.mock.message(0).property("CamelToEndpoint")).isEqualTo((Object)"mock://mock");
        this.template.sendBody("direct:enricher-test-1", (Object)"test");
        this.mock.assertIsSatisfied();
    }

    public void testEnrichFaultInOnly() throws InterruptedException {
        this.mock.expectedMessageCount(0);
        Exchange exchange = this.template.send("direct:enricher-test-3", new Processor(){

            public void process(Exchange exchange) {
                exchange.getIn().setBody((Object)"test");
            }
        });
        this.mock.assertIsSatisfied();
        EnricherTest.assertEquals((Object)"test", (Object)exchange.getIn().getBody());
        EnricherTest.assertTrue((exchange.getOut() != null && exchange.getOut().isFault() ? 1 : 0) != 0);
        EnricherTest.assertEquals((Object)"failed", (Object)exchange.getOut().getBody());
        EnricherTest.assertEquals((Object)"direct://enricher-fault-resource", (Object)exchange.getProperty("CamelToEndpoint"));
        EnricherTest.assertNull((Object)exchange.getException());
    }

    public void testEnrichErrorInOnly() throws InterruptedException {
        this.mock.expectedMessageCount(0);
        Exchange exchange = this.template.send("direct:enricher-test-4", new Processor(){

            public void process(Exchange exchange) {
                exchange.getIn().setBody((Object)"test");
            }
        });
        this.mock.assertIsSatisfied();
        EnricherTest.assertEquals((Object)"test", (Object)exchange.getIn().getBody());
        EnricherTest.assertEquals((String)"failed", (String)exchange.getException().getMessage());
        EnricherTest.assertFalse((boolean)exchange.hasOut());
    }

    public void testEnrichInOut() throws InterruptedException {
        String result = (String)this.template.sendBody("direct:enricher-test-5", ExchangePattern.InOut, (Object)"test");
        EnricherTest.assertEquals((String)"test:blah", (String)result);
    }

    public void testEnrichInOutPlusHeader() throws InterruptedException {
        Exchange exchange = this.template.send("direct:enricher-test-5", ExchangePattern.InOut, new Processor(){

            public void process(Exchange exchange) {
                exchange.getIn().setHeader("foo", (Object)"bar");
                exchange.getIn().setBody((Object)"test");
            }
        });
        EnricherTest.assertEquals((Object)"bar", (Object)exchange.getIn().getHeader("foo"));
        EnricherTest.assertEquals((Object)"test:blah", (Object)exchange.getIn().getBody());
        EnricherTest.assertTrue((boolean)exchange.hasOut());
        EnricherTest.assertNull((Object)exchange.getException());
    }

    public void testEnrichFaultInOut() throws InterruptedException {
        Exchange exchange = this.template.send("direct:enricher-test-7", ExchangePattern.InOut, new Processor(){

            public void process(Exchange exchange) {
                exchange.getIn().setBody((Object)"test");
            }
        });
        EnricherTest.assertEquals((Object)"test", (Object)exchange.getIn().getBody());
        EnricherTest.assertTrue((exchange.getOut() != null && exchange.getOut().isFault() ? 1 : 0) != 0);
        EnricherTest.assertEquals((Object)"failed", (Object)exchange.getOut().getBody());
        EnricherTest.assertNull((Object)exchange.getException());
    }

    public void testEnrichErrorInOut() throws InterruptedException {
        Exchange exchange = this.template.send("direct:enricher-test-8", ExchangePattern.InOut, new Processor(){

            public void process(Exchange exchange) {
                exchange.getIn().setBody((Object)"test");
            }
        });
        EnricherTest.assertEquals((Object)"test", (Object)exchange.getIn().getBody());
        EnricherTest.assertEquals((String)"failed", (String)exchange.getException().getMessage());
        EnricherTest.assertFalse((boolean)exchange.hasOut());
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:enricher-test-1").enrich("direct:enricher-constant-resource", (AggregationStrategy)aggregationStrategy)).to("mock:mock");
                ((RouteDefinition)this.from("direct:enricher-test-3").enrich("direct:enricher-fault-resource", (AggregationStrategy)aggregationStrategy)).to("mock:mock");
                ((RouteDefinition)this.from("direct:enricher-test-4").errorHandler((ErrorHandlerFactory)this.noErrorHandler()).enrich("direct:enricher-error-resource", (AggregationStrategy)aggregationStrategy)).to("mock:mock");
                this.from("direct:enricher-test-5").enrich("direct:enricher-constant-resource", (AggregationStrategy)aggregationStrategy);
                this.from("direct:enricher-test-7").enrich("direct:enricher-fault-resource", (AggregationStrategy)aggregationStrategy);
                this.from("direct:enricher-test-8").errorHandler((ErrorHandlerFactory)this.noErrorHandler()).enrich("direct:enricher-error-resource", (AggregationStrategy)aggregationStrategy);
                this.from("direct:enricher-constant-resource").transform().constant((Object)"blah");
                this.from("direct:enricher-fault-resource").errorHandler((ErrorHandlerFactory)this.noErrorHandler()).process((Processor)new FailureProcessor(false));
                this.from("direct:enricher-error-resource").errorHandler((ErrorHandlerFactory)this.noErrorHandler()).process((Processor)new FailureProcessor(true));
            }
        };
    }
}

