/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.interceptor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.AdviceWithRouteBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.MulticastDefinition;
import org.apache.camel.model.RouteDefinition;

public class AdviceWithTasksToStringPatternTest
extends ContextTestSupport {
    public void testUnknownId() throws Exception {
        try {
            ((RouteDefinition)this.context.getRouteDefinitions().get(0)).adviceWith(this.context, (RouteBuilder)new AdviceWithRouteBuilder(){

                public void configure() throws Exception {
                    this.weaveByToString("xxx").replace().to("mock:xxx");
                }
            });
            AdviceWithTasksToStringPatternTest.fail((String)"Should hve thrown exception");
        }
        catch (IllegalArgumentException e) {
            AdviceWithTasksToStringPatternTest.assertTrue((String)e.getMessage(), (boolean)e.getMessage().startsWith("There are no outputs which matches: xxx in the route"));
        }
    }

    public void testReplace() throws Exception {
        ((RouteDefinition)this.context.getRouteDefinitions().get(0)).adviceWith(this.context, (RouteBuilder)new AdviceWithRouteBuilder(){

            public void configure() throws Exception {
                ((MulticastDefinition)this.weaveByToString(".*foo.*").replace().multicast().to("mock:a")).to("mock:b");
            }
        });
        this.getMockEndpoint("mock:foo").expectedMessageCount(0);
        this.getMockEndpoint("mock:a").expectedMessageCount(1);
        this.getMockEndpoint("mock:b").expectedMessageCount(1);
        this.getMockEndpoint("mock:bar").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    public void testRemove() throws Exception {
        ((RouteDefinition)this.context.getRouteDefinitions().get(0)).adviceWith(this.context, (RouteBuilder)new AdviceWithRouteBuilder(){

            public void configure() throws Exception {
                this.weaveByToString(".*bar.*").remove();
            }
        });
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        AdviceWithTasksToStringPatternTest.assertFalse((String)"Should not have removed id", (this.context.hasEndpoint("mock:bar") == null ? 1 : 0) != 0);
    }

    public void testBefore() throws Exception {
        ((RouteDefinition)this.context.getRouteDefinitions().get(0)).adviceWith(this.context, (RouteBuilder)new AdviceWithRouteBuilder(){

            public void configure() throws Exception {
                this.weaveByToString(".*bar.*").before().to("mock:a").transform((Expression)this.constant("Bye World"));
            }
        });
        this.getMockEndpoint("mock:foo").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:a").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:bar").expectedBodiesReceived(new Object[]{"Bye World"});
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Bye World"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    public void testAfter() throws Exception {
        ((RouteDefinition)this.context.getRouteDefinitions().get(0)).adviceWith(this.context, (RouteBuilder)new AdviceWithRouteBuilder(){

            public void configure() throws Exception {
                this.weaveByToString(".*bar.*").after().to("mock:a").transform((Expression)this.constant("Bye World"));
            }
        });
        this.getMockEndpoint("mock:foo").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:a").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:bar").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Bye World"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)((RouteDefinition)this.from("direct:start").to("mock:foo")).to("mock:bar")).to("mock:result");
            }
        };
    }
}

