/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.interceptor;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.interceptor.DefaultTraceEventMessage;
import org.apache.camel.processor.interceptor.Tracer;
import org.apache.camel.spi.InterceptStrategy;

public class DefaultTraceEventMessageCausedByExceptionTest
extends ContextTestSupport {
    public void testCausedByException() throws Exception {
        this.getMockEndpoint("mock:handled").expectedMessageCount(1);
        MockEndpoint traced = this.getMockEndpoint("mock:traced");
        traced.expectedMessageCount(4);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        DefaultTraceEventMessage em1 = (DefaultTraceEventMessage)((Exchange)traced.getReceivedExchanges().get(0)).getIn().getBody(DefaultTraceEventMessage.class);
        DefaultTraceEventMessage em2 = (DefaultTraceEventMessage)((Exchange)traced.getReceivedExchanges().get(1)).getIn().getBody(DefaultTraceEventMessage.class);
        DefaultTraceEventMessage em3 = (DefaultTraceEventMessage)((Exchange)traced.getReceivedExchanges().get(2)).getIn().getBody(DefaultTraceEventMessage.class);
        DefaultTraceEventMessage em4 = (DefaultTraceEventMessage)((Exchange)traced.getReceivedExchanges().get(3)).getIn().getBody(DefaultTraceEventMessage.class);
        DefaultTraceEventMessageCausedByExceptionTest.assertNotNull((Object)em1);
        DefaultTraceEventMessageCausedByExceptionTest.assertNotNull((Object)em2);
        DefaultTraceEventMessageCausedByExceptionTest.assertNotNull((Object)em3);
        DefaultTraceEventMessageCausedByExceptionTest.assertNotNull((Object)em4);
        DefaultTraceEventMessageCausedByExceptionTest.assertNull((Object)em1.getCausedByException());
        DefaultTraceEventMessageCausedByExceptionTest.assertNull((Object)em2.getCausedByException());
        DefaultTraceEventMessageCausedByExceptionTest.assertEquals((String)"java.lang.IllegalArgumentException: Forced", (String)em3.getCausedByException());
        DefaultTraceEventMessageCausedByExceptionTest.assertEquals((String)"java.lang.IllegalArgumentException: Forced", (String)em4.getCausedByException());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                Tracer tracer = Tracer.createTracer((CamelContext)DefaultTraceEventMessageCausedByExceptionTest.this.context);
                tracer.setDestinationUri("mock:traced");
                DefaultTraceEventMessageCausedByExceptionTest.this.context.addInterceptStrategy((InterceptStrategy)tracer);
                this.onException(Exception.class).handled(true).to("mock:handled");
                ((RouteDefinition)this.from("direct:start").to("mock:foo")).throwException((Exception)new IllegalArgumentException("Forced"));
            }
        };
    }
}

