/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.interceptor;

import java.util.Date;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.interceptor.DefaultTraceEventMessage;
import org.apache.camel.processor.interceptor.Tracer;
import org.apache.camel.spi.InterceptStrategy;

public class DefaultTraceEventMessageTest
extends ContextTestSupport {
    public void testDefaultTraceEventMessage() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        MockEndpoint traced = this.getMockEndpoint("mock:traced");
        traced.expectedMessageCount(2);
        this.template.send("direct:start", new Processor(){

            public void process(Exchange exchange) throws Exception {
                exchange.setPattern(ExchangePattern.InOut);
                exchange.setProperty("foo", (Object)123);
                exchange.getIn().setBody((Object)"Hello World");
                exchange.getIn().setHeader("bar", (Object)"456");
                exchange.getOut().setBody((Object)"Bye World");
                exchange.getOut().setHeader("cheese", (Object)789);
            }
        });
        this.assertMockEndpointsSatisfied();
        DefaultTraceEventMessage em = (DefaultTraceEventMessage)((Exchange)traced.getReceivedExchanges().get(0)).getIn().getBody(DefaultTraceEventMessage.class);
        DefaultTraceEventMessageTest.assertNotNull((Object)em);
        DefaultTraceEventMessageTest.assertNotNull((Object)em.getTimestamp());
        DefaultTraceEventMessageTest.assertEquals((String)"direct://start", (String)em.getFromEndpointUri());
        DefaultTraceEventMessageTest.assertEquals(null, (String)em.getPreviousNode());
        DefaultTraceEventMessageTest.assertEquals((String)"mock://foo", (String)em.getToNode());
        DefaultTraceEventMessageTest.assertNotNull((Object)em.getExchangeId());
        DefaultTraceEventMessageTest.assertNotNull((Object)em.getShortExchangeId());
        DefaultTraceEventMessageTest.assertEquals((String)"InOut", (String)em.getExchangePattern());
        DefaultTraceEventMessageTest.assertTrue((boolean)em.getProperties().contains("foo=123"));
        DefaultTraceEventMessageTest.assertTrue((boolean)em.getProperties().contains("CamelToEndpoint=direct://start"));
        DefaultTraceEventMessageTest.assertTrue((boolean)em.getProperties().contains("CamelCreatedTimestamp"));
        DefaultTraceEventMessageTest.assertTrue((boolean)em.getHeaders().contains("bar=456"));
        DefaultTraceEventMessageTest.assertEquals((String)"Hello World", (String)em.getBody());
        DefaultTraceEventMessageTest.assertEquals((String)"String", (String)em.getBodyType());
        DefaultTraceEventMessageTest.assertEquals((String)"Bye World", (String)em.getOutBody());
        DefaultTraceEventMessageTest.assertEquals((String)"String", (String)em.getOutBodyType());
        DefaultTraceEventMessageTest.assertEquals((String)"{cheese=789}", (String)em.getOutHeaders());
    }

    public void testDefaultTraceEventMessageOptions() throws Exception {
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        DefaultTraceEventMessage em = new DefaultTraceEventMessage(new Date(), null, (Exchange)exchange);
        em.setBody("Hello World");
        DefaultTraceEventMessageTest.assertEquals((String)"Hello World", (String)em.getBody());
        em.setBodyType("String");
        DefaultTraceEventMessageTest.assertEquals((String)"String", (String)em.getBodyType());
        em.setCausedByException("Damn");
        DefaultTraceEventMessageTest.assertEquals((String)"Damn", (String)em.getCausedByException());
        em.setExchangeId("123");
        DefaultTraceEventMessageTest.assertEquals((String)"123", (String)em.getExchangeId());
        em.setExchangePattern("InOnly");
        DefaultTraceEventMessageTest.assertEquals((String)"InOnly", (String)em.getExchangePattern());
        em.setFromEndpointUri("direct://start");
        DefaultTraceEventMessageTest.assertEquals((String)"direct://start", (String)em.getFromEndpointUri());
        em.setHeaders("{foo=123}");
        DefaultTraceEventMessageTest.assertEquals((String)"{foo=123}", (String)em.getHeaders());
        em.setOutBody("123");
        DefaultTraceEventMessageTest.assertEquals((String)"123", (String)em.getOutBody());
        em.setOutBodyType("Integer");
        DefaultTraceEventMessageTest.assertEquals((String)"Integer", (String)em.getOutBodyType());
        em.setOutHeaders("{cheese=789}");
        DefaultTraceEventMessageTest.assertEquals((String)"{cheese=789}", (String)em.getOutHeaders());
        em.setProperties("{foo=123}");
        DefaultTraceEventMessageTest.assertEquals((String)"{foo=123}", (String)em.getProperties());
        em.setPreviousNode("A");
        DefaultTraceEventMessageTest.assertEquals((String)"A", (String)em.getPreviousNode());
        em.setToNode("B");
        DefaultTraceEventMessageTest.assertEquals((String)"B", (String)em.getToNode());
        em.setTimestamp(new Date());
        DefaultTraceEventMessageTest.assertNotNull((Object)em.getTimestamp());
        em.setShortExchangeId("123");
        DefaultTraceEventMessageTest.assertEquals((String)"123", (String)em.getShortExchangeId());
        DefaultTraceEventMessageTest.assertSame((Object)exchange, (Object)em.getTracedExchange());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                Tracer tracer = Tracer.createTracer((CamelContext)DefaultTraceEventMessageTest.this.context);
                tracer.setDestinationUri("mock:traced");
                DefaultTraceEventMessageTest.this.context.addInterceptStrategy((InterceptStrategy)tracer);
                ((RouteDefinition)this.from("direct:start").to("mock:foo")).to("mock:result");
            }
        };
    }
}

