/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.interceptor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.interceptor.DefaultTraceFormatter;
import org.apache.camel.processor.interceptor.TraceFormatter;
import org.apache.camel.processor.interceptor.Tracer;
import org.apache.camel.spi.InterceptStrategy;

public class DefaultTraceFormatterTest
extends ContextTestSupport {
    public void testDefaultTraceFormatter() {
        this.getFormatter();
    }

    public void testFormat() throws Exception {
        Tracer tracer = new Tracer();
        tracer.setFormatter((TraceFormatter)this.getFormatter());
        this.context.addInterceptStrategy((InterceptStrategy)tracer);
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        this.template.send("direct:start", new Processor(){

            public void process(Exchange exchange) throws Exception {
                exchange.getIn().setBody((Object)"Hello World");
                exchange.getIn().setHeader("foo", (Object)123);
                exchange.getOut().setBody((Object)"Bye World");
                exchange.getOut().setHeader("bar", (Object)456);
                exchange.setProperty("quote", (Object)"Camel is cool");
            }
        });
        this.assertMockEndpointsSatisfied();
    }

    public void testWithException() throws Exception {
        Tracer tracer = new Tracer();
        tracer.setFormatter((TraceFormatter)this.getFormatter());
        this.context.addInterceptStrategy((InterceptStrategy)tracer);
        try {
            this.template.sendBody("direct:fail", (Object)"Hello World");
            DefaultTraceFormatterTest.fail((String)"Should have thrown an exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testNoShow() throws Exception {
        DefaultTraceFormatter formatter = this.getFormatter();
        formatter.setShowBreadCrumb(false);
        formatter.setShowExchangeId(false);
        formatter.setShowShortExchangeId(false);
        formatter.setShowNode(false);
        Tracer tracer = new Tracer();
        tracer.setFormatter((TraceFormatter)formatter);
        this.context.addInterceptStrategy((InterceptStrategy)tracer);
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to("mock:result");
                ((RouteDefinition)this.from("direct:fail").to("mock:mid")).throwException((Exception)new IllegalArgumentException("Damn"));
            }
        };
    }

    private DefaultTraceFormatter getFormatter() {
        DefaultTraceFormatter formatter = new DefaultTraceFormatter();
        formatter.setBreadCrumbLength(30);
        DefaultTraceFormatterTest.assertEquals((int)30, (int)formatter.getBreadCrumbLength());
        formatter.setMaxChars(500);
        DefaultTraceFormatterTest.assertEquals((int)500, (int)formatter.getMaxChars());
        formatter.setNodeLength(20);
        DefaultTraceFormatterTest.assertEquals((int)20, (int)formatter.getNodeLength());
        formatter.setShowBody(true);
        DefaultTraceFormatterTest.assertEquals((boolean)true, (boolean)formatter.isShowBody());
        formatter.setBreadCrumbLength(40);
        DefaultTraceFormatterTest.assertEquals((int)40, (int)formatter.getBreadCrumbLength());
        formatter.setShowBody(true);
        DefaultTraceFormatterTest.assertEquals((boolean)true, (boolean)formatter.isShowBody());
        formatter.setShowBodyType(true);
        DefaultTraceFormatterTest.assertEquals((boolean)true, (boolean)formatter.isShowBodyType());
        formatter.setShowBreadCrumb(true);
        DefaultTraceFormatterTest.assertEquals((boolean)true, (boolean)formatter.isShowBreadCrumb());
        formatter.setShowExchangeId(true);
        DefaultTraceFormatterTest.assertEquals((boolean)true, (boolean)formatter.isShowExchangeId());
        formatter.setShowException(true);
        DefaultTraceFormatterTest.assertEquals((boolean)true, (boolean)formatter.isShowException());
        formatter.setShowExchangePattern(true);
        DefaultTraceFormatterTest.assertEquals((boolean)true, (boolean)formatter.isShowExchangePattern());
        formatter.setShowHeaders(true);
        DefaultTraceFormatterTest.assertEquals((boolean)true, (boolean)formatter.isShowHeaders());
        formatter.setShowNode(true);
        DefaultTraceFormatterTest.assertEquals((boolean)true, (boolean)formatter.isShowNode());
        formatter.setShowOutBody(true);
        DefaultTraceFormatterTest.assertEquals((boolean)true, (boolean)formatter.isShowOutBody());
        formatter.setShowOutBodyType(true);
        DefaultTraceFormatterTest.assertEquals((boolean)true, (boolean)formatter.isShowOutBodyType());
        formatter.setShowOutHeaders(true);
        DefaultTraceFormatterTest.assertEquals((boolean)true, (boolean)formatter.isShowOutHeaders());
        formatter.setShowProperties(true);
        DefaultTraceFormatterTest.assertEquals((boolean)true, (boolean)formatter.isShowProperties());
        formatter.setShowShortExchangeId(true);
        DefaultTraceFormatterTest.assertEquals((boolean)true, (boolean)formatter.isShowShortExchangeId());
        formatter.setShowRouteId(false);
        DefaultTraceFormatterTest.assertEquals((boolean)false, (boolean)formatter.isShowRouteId());
        return formatter;
    }
}

