/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.interceptor;

import java.io.ByteArrayInputStream;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.StreamCache;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;

public class NoStreamCachingTest
extends ContextTestSupport {
    private static final String MESSAGE = "<hello>world!</hello>";
    private MockEndpoint a;
    private MockEndpoint b;

    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.a = this.getMockEndpoint("mock:a");
        this.b = this.getMockEndpoint("mock:b");
    }

    public void testNoStreamCache() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:a").noStreamCaching().to("mock:a");
            }
        });
        this.context.start();
        this.a.expectedMessageCount(1);
        ByteArrayInputStream message = new ByteArrayInputStream(MESSAGE.getBytes());
        this.template.sendBody("direct:a", (Object)message);
        this.assertMockEndpointsSatisfied();
        NoStreamCachingTest.assertTrue((boolean)(this.a.assertExchangeReceived(0).getIn().getBody() instanceof ByteArrayInputStream));
        NoStreamCachingTest.assertEquals((String)((String)this.a.assertExchangeReceived(0).getIn().getBody(String.class)), (String)MESSAGE);
    }

    public void testNoStreamCacheIsDefault() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:a").to("mock:a");
            }
        });
        this.context.start();
        this.a.expectedMessageCount(1);
        ByteArrayInputStream message = new ByteArrayInputStream(MESSAGE.getBytes());
        this.template.sendBody("direct:a", (Object)message);
        this.assertMockEndpointsSatisfied();
        NoStreamCachingTest.assertTrue((boolean)(this.a.assertExchangeReceived(0).getIn().getBody() instanceof ByteArrayInputStream));
        NoStreamCachingTest.assertEquals((String)((String)this.a.assertExchangeReceived(0).getIn().getBody(String.class)), (String)MESSAGE);
    }

    public void testMixed() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:a").to("mock:a");
                this.from("direct:b").streamCaching().to("mock:b");
            }
        });
        this.context.start();
        this.a.expectedMessageCount(1);
        this.b.expectedMessageCount(1);
        ByteArrayInputStream message = new ByteArrayInputStream(MESSAGE.getBytes());
        this.template.sendBody("direct:a", (Object)message);
        ByteArrayInputStream message2 = new ByteArrayInputStream(MESSAGE.getBytes());
        this.template.sendBody("direct:b", (Object)message2);
        this.assertMockEndpointsSatisfied();
        NoStreamCachingTest.assertTrue((boolean)(this.a.assertExchangeReceived(0).getIn().getBody() instanceof ByteArrayInputStream));
        NoStreamCachingTest.assertEquals((String)((String)this.a.assertExchangeReceived(0).getIn().getBody(String.class)), (String)MESSAGE);
        NoStreamCachingTest.assertTrue((boolean)(this.b.assertExchangeReceived(0).getIn().getBody() instanceof StreamCache));
        NoStreamCachingTest.assertEquals((String)((String)this.b.assertExchangeReceived(0).getIn().getBody(String.class)), (String)MESSAGE);
    }
}

