/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.interceptor;

import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.processor.interceptor.TraceInterceptorCustomJpaMessage;
import org.apache.camel.processor.interceptor.Tracer;
import org.apache.camel.processor.interceptor.TracingTestBase;

public class TraceInterceptorCustomJpaMessageTest
extends TracingTestBase {
    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext contextLocal = super.createCamelContext();
        Tracer tracer = (Tracer)contextLocal.getDefaultTracer();
        tracer.setEnabled(true);
        tracer.setTraceExceptions(true);
        tracer.setUseJpa(true);
        tracer.setDestinationUri("mock:jpa-trace");
        tracer.setJpaTraceEventMessageClassName("org.apache.camel.processor.interceptor.TraceInterceptorCustomJpaMessage");
        return contextLocal;
    }

    @Override
    protected void prepareTestTracerInOnly() {
        MockEndpoint traces = this.getMockEndpoint("mock:jpa-trace");
        traces.expectedMessageCount(6);
    }

    @Override
    protected void prepareTestTracerInOut() {
        MockEndpoint traces = this.getMockEndpoint("mock:jpa-trace");
        traces.expectedMessageCount(12);
    }

    @Override
    protected void prepareTestTracerExceptionInOut() {
        MockEndpoint traces = this.getMockEndpoint("mock:jpa-trace");
        traces.expectedMessageCount(10);
    }

    @Override
    protected void validateTestTracerInOnly() {
        MockEndpoint traces = this.getMockEndpoint("mock:jpa-trace");
        TraceInterceptorCustomJpaMessageTest.assertEquals((int)6, (int)traces.getExchanges().size());
        for (Exchange exchange : traces.getExchanges()) {
            TraceInterceptorCustomJpaMessageTest.assertEquals(exchange.getIn().getBody().getClass(), TraceInterceptorCustomJpaMessage.class);
        }
    }

    @Override
    protected void validateTestTracerInOut() {
        MockEndpoint traces = this.getMockEndpoint("mock:jpa-trace");
        TraceInterceptorCustomJpaMessageTest.assertEquals((int)12, (int)traces.getExchanges().size());
        for (Exchange exchange : traces.getExchanges()) {
            TraceInterceptorCustomJpaMessageTest.assertEquals(exchange.getIn().getBody().getClass(), TraceInterceptorCustomJpaMessage.class);
        }
    }

    @Override
    protected void validateTestTracerExceptionInOut() {
        MockEndpoint traces = this.getMockEndpoint("mock:jpa-trace");
        TraceInterceptorCustomJpaMessageTest.assertEquals((int)10, (int)traces.getExchanges().size());
        for (Exchange exchange : traces.getExchanges()) {
            TraceInterceptorCustomJpaMessageTest.assertEquals(exchange.getIn().getBody().getClass(), TraceInterceptorCustomJpaMessage.class);
        }
    }

    @Override
    protected int getMessageCount() {
        MockEndpoint traces = this.getMockEndpoint("mock:jpa-trace");
        return traces.getExchanges().size();
    }
}

