/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.interceptor;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.processor.interceptor.DefaultTraceEventMessage;
import org.apache.camel.processor.interceptor.DefaultTraceFormatter;
import org.apache.camel.processor.interceptor.Tracer;
import org.apache.camel.spi.InterceptStrategy;

public class TracerTest
extends ContextTestSupport {
    private Tracer tracer;

    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("traceFormatter", (Object)new DefaultTraceFormatter());
        return jndi;
    }

    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        this.tracer = Tracer.createTracer((CamelContext)context);
        this.tracer.setEnabled(true);
        this.tracer.setTraceInterceptors(true);
        this.tracer.setTraceFilter(TracerTest.body().contains((Object)"Camel"));
        this.tracer.setTraceExceptions(true);
        this.tracer.setLogStackTrace(true);
        this.tracer.setUseJpa(false);
        this.tracer.setDestination(context.getEndpoint("mock:traced"));
        context.addInterceptStrategy((InterceptStrategy)this.tracer);
        this.tracer.start();
        return context;
    }

    @Override
    protected void tearDown() throws Exception {
        this.tracer.stop();
        super.tearDown();
    }

    public void testTracer() throws Exception {
        MockEndpoint tracer = this.getMockEndpoint("mock:traced");
        tracer.expectedMessageCount(1);
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedMessageCount(3);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.template.sendBody("direct:start", (Object)"Bye World");
        this.template.sendBody("direct:start", (Object)"Hello Camel");
        this.assertMockEndpointsSatisfied();
        DefaultTraceEventMessage em = (DefaultTraceEventMessage)((Exchange)tracer.getReceivedExchanges().get(0)).getIn().getBody(DefaultTraceEventMessage.class);
        TracerTest.assertEquals((String)"Hello Camel", (String)em.getBody());
        TracerTest.assertEquals((String)"String", (String)em.getBodyType());
        TracerTest.assertEquals(null, (String)em.getCausedByException());
        TracerTest.assertNotNull((Object)em.getExchangeId());
        TracerTest.assertNotNull((Object)em.getShortExchangeId());
        TracerTest.assertNotNull((Object)em.getExchangePattern());
        TracerTest.assertEquals((String)"direct://start", (String)em.getFromEndpointUri());
        TracerTest.assertNotNull((Object)em.getHeaders());
        TracerTest.assertNotNull((Object)em.getProperties());
        TracerTest.assertNull((Object)em.getOutBody());
        TracerTest.assertNull((Object)em.getOutBodyType());
        TracerTest.assertNull((Object)em.getOutHeaders());
        TracerTest.assertNull((Object)em.getPreviousNode());
        TracerTest.assertNotNull((Object)em.getToNode());
        TracerTest.assertNotNull((Object)em.getTimestamp());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to("mock:result");
            }
        };
    }
}

