/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.onexception;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.processor.onexception.MyFunctionalException;

public class DefaultErrorHandlerRetryWhileTest
extends ContextTestSupport {
    private static int invoked;

    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("myRetryHandler", (Object)new MyRetryBean());
        return jndi;
    }

    public void testRetryUntil() throws Exception {
        Object out = this.template.requestBody("direct:start", (Object)"Hello World");
        DefaultErrorHandlerRetryWhileTest.assertEquals((Object)"Bye World", (Object)out);
        DefaultErrorHandlerRetryWhileTest.assertEquals((int)3, (int)invoked);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.errorHandler((ErrorHandlerBuilder)this.defaultErrorHandler().retryWhile((Expression)this.method("myRetryHandler")));
                this.from("direct:start").process((Processor)new MyProcessor());
            }
        };
    }

    public static class MyRetryBean {
        public boolean retry() {
            invoked++;
            return true;
        }
    }

    public static class MyProcessor
    implements Processor {
        public void process(Exchange exchange) throws Exception {
            if (invoked < 3) {
                throw new MyFunctionalException("Sorry you cannot do this");
            }
            exchange.getIn().setBody((Object)"Bye World");
        }
    }
}

