/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.onexception;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.converter.stream.InputStreamCache;
import org.apache.camel.model.RouteDefinition;

public class OnExceptionUseOriginalMessageTest
extends ContextTestSupport {
    private static final String HELLO_WORLD = "Hello World";
    private static final String TEST_STRING = "<firstName>James</firstName>";

    public void testOnExceptionError() throws Exception {
        this.getMockEndpoint("mock:middle").expectedBodiesReceived(new Object[]{HELLO_WORLD});
        ((ValueBuilder)this.getMockEndpoint("mock:middle").message(0).property("CamelExceptionCaught")).isInstanceOf(IllegalArgumentException.class);
        this.getMockEndpoint("mock:end").expectedBodiesReceived(new Object[]{HELLO_WORLD});
        ((ValueBuilder)this.getMockEndpoint("mock:end").message(0).property("CamelExceptionCaught")).isInstanceOf(IllegalArgumentException.class);
        this.template.sendBody("direct:a", (Object)HELLO_WORLD);
        this.assertMockEndpointsSatisfied();
    }

    public void testOnExceptionStreamReset() throws Exception {
        this.getMockEndpoint("mock:middle").expectedMessageCount(1);
        ((ValueBuilder)this.getMockEndpoint("mock:middle").message(0).property("CamelExceptionCaught")).isInstanceOf(IllegalArgumentException.class);
        this.getMockEndpoint("mock:end").expectedMessageCount(1);
        ((ValueBuilder)this.getMockEndpoint("mock:end").message(0).property("CamelExceptionCaught")).isInstanceOf(IllegalArgumentException.class);
        InputStreamCache cache = new InputStreamCache(TEST_STRING.getBytes());
        this.template.sendBody("direct:a", (Object)cache);
        this.assertMockEndpointsSatisfied();
        String result = (String)((Exchange)this.getMockEndpoint("mock:end").getExchanges().get(0)).getIn().getBody(String.class);
        OnExceptionUseOriginalMessageTest.assertTrue((boolean)result.contains(TEST_STRING));
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.onException(IllegalArgumentException.class).useOriginalMessage().handled(true).to("seda:test");
                ((RouteDefinition)this.from("direct:a").setExchangePattern(ExchangePattern.InOut)).process((Processor)new MyProcessor());
                ((RouteDefinition)this.from("seda:test").to("mock:middle")).to("mock:end");
            }
        };
    }

    public static class MyProcessor
    implements Processor {
        public void process(Exchange exchange) throws Exception {
            String request = (String)exchange.getIn().getBody(String.class);
            if (!request.equals(OnExceptionUseOriginalMessageTest.HELLO_WORLD)) {
                exchange.getIn().setBody((Object)OnExceptionUseOriginalMessageTest.HELLO_WORLD);
            }
            exchange.getOut().setBody((Object)"Error body");
            throw new IllegalArgumentException("Get a wrong message");
        }
    }
}

