/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.validation;

import javax.xml.transform.Result;
import javax.xml.transform.sax.SAXResult;
import javax.xml.validation.Schema;
import javax.xml.validation.Validator;
import javax.xml.validation.ValidatorHandler;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.processor.validation.DefaultValidationErrorHandler;
import org.apache.camel.processor.validation.SchemaValidationException;
import org.xml.sax.Locator;
import org.xml.sax.SAXParseException;

public class DefaultValidationErrorHandlerTest
extends ContextTestSupport {
    public void testWarning() throws Exception {
        DefaultValidationErrorHandler eh = new DefaultValidationErrorHandler();
        eh.warning(new SAXParseException("foo", this.createLocator(1, 2)));
        DefaultValidationErrorHandlerTest.assertEquals((boolean)true, (boolean)eh.isValid());
    }

    public void testError() throws Exception {
        DefaultValidationErrorHandler eh = new DefaultValidationErrorHandler();
        eh.error(new SAXParseException("foo", this.createLocator(3, 5)));
        DefaultValidationErrorHandlerTest.assertEquals((boolean)false, (boolean)eh.isValid());
    }

    public void testFatalError() throws Exception {
        DefaultValidationErrorHandler eh = new DefaultValidationErrorHandler();
        eh.fatalError(new SAXParseException("foo", this.createLocator(5, 8)));
        DefaultValidationErrorHandlerTest.assertEquals((boolean)false, (boolean)eh.isValid());
    }

    public void testReset() throws Exception {
        DefaultValidationErrorHandler eh = new DefaultValidationErrorHandler();
        eh.fatalError(new SAXParseException("foo", this.createLocator(5, 8)));
        DefaultValidationErrorHandlerTest.assertEquals((boolean)false, (boolean)eh.isValid());
        eh.reset();
        DefaultValidationErrorHandlerTest.assertEquals((boolean)true, (boolean)eh.isValid());
    }

    public void testHandleErrors() throws Exception {
        DefaultValidationErrorHandler eh = new DefaultValidationErrorHandler();
        eh.error(new SAXParseException("foo", this.createLocator(3, 5)));
        eh.error(new SAXParseException("bar", this.createLocator(9, 12)));
        eh.fatalError(new SAXParseException("cheese", this.createLocator(13, 17)));
        DefaultValidationErrorHandlerTest.assertEquals((boolean)false, (boolean)eh.isValid());
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        try {
            eh.handleErrors((Exchange)exchange, (Object)this.createScheme());
            DefaultValidationErrorHandlerTest.fail((String)"Should have thrown an exception");
        }
        catch (SchemaValidationException e) {
            DefaultValidationErrorHandlerTest.assertEquals((int)2, (int)e.getErrors().size());
            DefaultValidationErrorHandlerTest.assertEquals((int)1, (int)e.getFatalErrors().size());
            DefaultValidationErrorHandlerTest.assertEquals((int)0, (int)e.getWarnings().size());
            DefaultValidationErrorHandlerTest.assertNotNull((Object)e.getSchema());
            DefaultValidationErrorHandlerTest.assertNotNull((Object)e.getExchange());
            DefaultValidationErrorHandlerTest.assertTrue((boolean)e.getMessage().startsWith("Validation failed for: org.apache.camel.processor.validation.DefaultValidationErrorHandlerTest"));
            DefaultValidationErrorHandlerTest.assertTrue((boolean)e.getMessage().contains("fatal errors: ["));
            DefaultValidationErrorHandlerTest.assertTrue((boolean)e.getMessage().contains("org.xml.sax.SAXParseException: cheese, Line : 13, Column : 17"));
            DefaultValidationErrorHandlerTest.assertTrue((boolean)e.getMessage().contains("errors: ["));
            DefaultValidationErrorHandlerTest.assertTrue((boolean)e.getMessage().contains("org.xml.sax.SAXParseException: foo, Line : 3, Column : 5"));
            DefaultValidationErrorHandlerTest.assertTrue((boolean)e.getMessage().contains("org.xml.sax.SAXParseException: bar, Line : 9, Column : 12"));
            DefaultValidationErrorHandlerTest.assertTrue((boolean)e.getMessage().contains("Exchange[null]"));
        }
    }

    public void testHandleErrorsResult() throws Exception {
        DefaultValidationErrorHandler eh = new DefaultValidationErrorHandler();
        eh.error(new SAXParseException("foo", this.createLocator(3, 5)));
        eh.error(new SAXParseException("bar", this.createLocator(9, 12)));
        DefaultValidationErrorHandlerTest.assertEquals((boolean)false, (boolean)eh.isValid());
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        try {
            eh.handleErrors((Exchange)exchange, this.createScheme(), (Result)new SAXResult());
            DefaultValidationErrorHandlerTest.fail((String)"Should have thrown an exception");
        }
        catch (SchemaValidationException e) {
            DefaultValidationErrorHandlerTest.assertEquals((int)2, (int)e.getErrors().size());
            DefaultValidationErrorHandlerTest.assertEquals((int)0, (int)e.getFatalErrors().size());
            DefaultValidationErrorHandlerTest.assertEquals((int)0, (int)e.getWarnings().size());
            DefaultValidationErrorHandlerTest.assertNotNull((Object)e.getSchema());
            DefaultValidationErrorHandlerTest.assertNotNull((Object)e.getExchange());
            DefaultValidationErrorHandlerTest.assertTrue((boolean)e.getMessage().startsWith("Validation failed for: org.apache.camel.processor.validation.DefaultValidationErrorHandlerTest"));
            DefaultValidationErrorHandlerTest.assertTrue((boolean)e.getMessage().contains("errors: ["));
            DefaultValidationErrorHandlerTest.assertTrue((boolean)e.getMessage().contains("org.xml.sax.SAXParseException: foo, Line : 3, Column : 5"));
            DefaultValidationErrorHandlerTest.assertTrue((boolean)e.getMessage().contains("org.xml.sax.SAXParseException: bar, Line : 9, Column : 12"));
            DefaultValidationErrorHandlerTest.assertTrue((boolean)e.getMessage().contains("Exchange[null]"));
        }
    }

    private Schema createScheme() {
        return new Schema(){

            @Override
            public Validator newValidator() {
                return null;
            }

            @Override
            public ValidatorHandler newValidatorHandler() {
                return null;
            }
        };
    }

    private Locator createLocator(final int line, final int column) {
        return new Locator(){

            @Override
            public String getSystemId() {
                return null;
            }

            @Override
            public String getPublicId() {
                return null;
            }

            @Override
            public int getLineNumber() {
                return line;
            }

            @Override
            public int getColumnNumber() {
                return column;
            }
        };
    }
}

