/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.NamedNode;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.converter.jaxp.XmlConverter;
import org.apache.camel.model.ModelHelper;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DumpModelAsXmlTransformRouteTest
extends ContextTestSupport {
    public void testDumpModelAsXml() throws Exception {
        String xml = ModelHelper.dumpModelAsXml((NamedNode)this.context.getRouteDefinition("myRoute"));
        DumpModelAsXmlTransformRouteTest.assertNotNull((Object)xml);
        this.log.info(xml);
        Document doc = new XmlConverter().toDOMDocument(xml);
        NodeList nodes = doc.getElementsByTagName("simple");
        DumpModelAsXmlTransformRouteTest.assertEquals((int)1, (int)nodes.getLength());
        Element node = (Element)nodes.item(0);
        DumpModelAsXmlTransformRouteTest.assertNotNull((String)"Node <simple> expected to be instanceof Element", (Object)node);
        DumpModelAsXmlTransformRouteTest.assertEquals((String)"Hello ${body}", (String)node.getTextContent());
        nodes = doc.getElementsByTagName("to");
        DumpModelAsXmlTransformRouteTest.assertEquals((int)1, (int)nodes.getLength());
        node = (Element)nodes.item(0);
        DumpModelAsXmlTransformRouteTest.assertNotNull((String)"Node <to> expected to be instanceof Element", (Object)node);
        DumpModelAsXmlTransformRouteTest.assertEquals((String)"mock:result", (String)node.getAttribute("uri"));
        DumpModelAsXmlTransformRouteTest.assertEquals((String)"myMock", (String)node.getAttribute("id"));
        DumpModelAsXmlTransformRouteTest.assertEquals((String)"true", (String)node.getAttribute("customId"));
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)((ProcessorDefinition)this.from("direct:start").routeId("myRoute").transform().simple("Hello ${body}")).to("mock:result")).id("myMock");
            }
        };
    }
}

