/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import junit.framework.TestCase;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.util.IOHelper;

public class IOHelperTest
extends TestCase {
    public void testIOException() {
        IOException io = new IOException("Damn", new IllegalArgumentException("Damn"));
        IOHelperTest.assertEquals((String)"Damn", (String)io.getMessage());
        IOHelperTest.assertTrue((boolean)(io.getCause() instanceof IllegalArgumentException));
    }

    public void testIOExceptionWithMessage() {
        IOException io = new IOException("Not again", new IllegalArgumentException("Damn"));
        IOHelperTest.assertEquals((String)"Not again", (String)io.getMessage());
        IOHelperTest.assertTrue((boolean)(io.getCause() instanceof IllegalArgumentException));
    }

    public void testNewStringFromBytes() {
        String s = IOHelper.newStringFromBytes((byte[])"Hello".getBytes());
        IOHelperTest.assertEquals((String)"Hello", (String)s);
    }

    public void testNewStringFromBytesWithStart() {
        String s = IOHelper.newStringFromBytes((byte[])"Hello".getBytes(), (int)2, (int)3);
        IOHelperTest.assertEquals((String)"llo", (String)s);
    }

    public void testCopyAndCloseInput() throws Exception {
        ByteArrayInputStream is = new ByteArrayInputStream("Hello".getBytes());
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        IOHelper.copyAndCloseInput((InputStream)is, (OutputStream)os, (int)256);
    }

    public void testCharsetNormalize() throws Exception {
        IOHelperTest.assertEquals((String)"UTF-8", (String)IOHelper.normalizeCharset((String)"'UTF-8'"));
        IOHelperTest.assertEquals((String)"UTF-8", (String)IOHelper.normalizeCharset((String)"\"UTF-8\""));
        IOHelperTest.assertEquals((String)"UTF-8", (String)IOHelper.normalizeCharset((String)"\"UTF-8 \""));
        IOHelperTest.assertEquals((String)"UTF-8", (String)IOHelper.normalizeCharset((String)"' UTF-8'"));
    }

    public void testCharsetName() throws Exception {
        DefaultExchange exchange = new DefaultExchange((CamelContext)null);
        IOHelperTest.assertNull((Object)IOHelper.getCharsetName((Exchange)exchange, (boolean)false));
        exchange.getIn().setHeader("CamelCharsetName", (Object)"iso-8859-1");
        IOHelperTest.assertEquals((String)"iso-8859-1", (String)IOHelper.getCharsetName((Exchange)exchange, (boolean)false));
        exchange.getIn().removeHeader("CamelCharsetName");
        exchange.setProperty("CamelCharsetName", (Object)"iso-8859-1");
        IOHelperTest.assertEquals((String)"iso-8859-1", (String)IOHelper.getCharsetName((Exchange)exchange, (boolean)false));
    }
}

