/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.util.ArrayList;
import java.util.Collections;
import junit.framework.TestCase;
import org.apache.camel.Ordered;
import org.apache.camel.util.OrderedComparator;

public class OrderedComparatorTest
extends TestCase {
    public void testOrderedComparator() throws Exception {
        ArrayList<MyOrder> answer = new ArrayList<MyOrder>();
        answer.add(new MyOrder(0));
        answer.add(new MyOrder(2));
        answer.add(new MyOrder(1));
        answer.add(new MyOrder(5));
        answer.add(new MyOrder(4));
        Collections.sort(answer, new OrderedComparator());
        OrderedComparatorTest.assertEquals((int)0, (int)((Ordered)answer.get(0)).getOrder());
        OrderedComparatorTest.assertEquals((int)1, (int)((Ordered)answer.get(1)).getOrder());
        OrderedComparatorTest.assertEquals((int)2, (int)((Ordered)answer.get(2)).getOrder());
        OrderedComparatorTest.assertEquals((int)4, (int)((Ordered)answer.get(3)).getOrder());
        OrderedComparatorTest.assertEquals((int)5, (int)((Ordered)answer.get(4)).getOrder());
    }

    public void testOrderedComparatorReverse() throws Exception {
        ArrayList<MyOrder> answer = new ArrayList<MyOrder>();
        answer.add(new MyOrder(0));
        answer.add(new MyOrder(2));
        answer.add(new MyOrder(1));
        answer.add(new MyOrder(5));
        answer.add(new MyOrder(4));
        Collections.sort(answer, new OrderedComparator(true));
        OrderedComparatorTest.assertEquals((int)5, (int)((Ordered)answer.get(0)).getOrder());
        OrderedComparatorTest.assertEquals((int)4, (int)((Ordered)answer.get(1)).getOrder());
        OrderedComparatorTest.assertEquals((int)2, (int)((Ordered)answer.get(2)).getOrder());
        OrderedComparatorTest.assertEquals((int)1, (int)((Ordered)answer.get(3)).getOrder());
        OrderedComparatorTest.assertEquals((int)0, (int)((Ordered)answer.get(4)).getOrder());
    }

    public void testOrderedComparatorHigh() throws Exception {
        ArrayList<MyOrder> answer = new ArrayList<MyOrder>();
        answer.add(new MyOrder(0));
        answer.add(new MyOrder(2));
        answer.add(new MyOrder(200));
        answer.add(new MyOrder(50));
        answer.add(new MyOrder(Integer.MIN_VALUE));
        answer.add(new MyOrder(4));
        Collections.sort(answer, new OrderedComparator());
        OrderedComparatorTest.assertEquals((int)Integer.MIN_VALUE, (int)((Ordered)answer.get(0)).getOrder());
        OrderedComparatorTest.assertEquals((int)0, (int)((Ordered)answer.get(1)).getOrder());
        OrderedComparatorTest.assertEquals((int)2, (int)((Ordered)answer.get(2)).getOrder());
        OrderedComparatorTest.assertEquals((int)4, (int)((Ordered)answer.get(3)).getOrder());
        OrderedComparatorTest.assertEquals((int)50, (int)((Ordered)answer.get(4)).getOrder());
        OrderedComparatorTest.assertEquals((int)200, (int)((Ordered)answer.get(5)).getOrder());
    }

    public void testOrderedComparatorHighReverse() throws Exception {
        ArrayList<MyOrder> answer = new ArrayList<MyOrder>();
        answer.add(new MyOrder(0));
        answer.add(new MyOrder(2));
        answer.add(new MyOrder(200));
        answer.add(new MyOrder(50));
        answer.add(new MyOrder(Integer.MIN_VALUE));
        answer.add(new MyOrder(4));
        Collections.sort(answer, new OrderedComparator(true));
        OrderedComparatorTest.assertEquals((int)200, (int)((Ordered)answer.get(0)).getOrder());
        OrderedComparatorTest.assertEquals((int)50, (int)((Ordered)answer.get(1)).getOrder());
        OrderedComparatorTest.assertEquals((int)4, (int)((Ordered)answer.get(2)).getOrder());
        OrderedComparatorTest.assertEquals((int)2, (int)((Ordered)answer.get(3)).getOrder());
        OrderedComparatorTest.assertEquals((int)0, (int)((Ordered)answer.get(4)).getOrder());
        OrderedComparatorTest.assertEquals((int)Integer.MIN_VALUE, (int)((Ordered)answer.get(5)).getOrder());
    }

    public void testOrderedComparatorLow() throws Exception {
        ArrayList<MyOrder> answer = new ArrayList<MyOrder>();
        answer.add(new MyOrder(0));
        answer.add(new MyOrder(-2));
        answer.add(new MyOrder(200));
        answer.add(new MyOrder(50));
        answer.add(new MyOrder(Integer.MAX_VALUE));
        answer.add(new MyOrder(-4));
        Collections.sort(answer, new OrderedComparator());
        OrderedComparatorTest.assertEquals((int)-4, (int)((Ordered)answer.get(0)).getOrder());
        OrderedComparatorTest.assertEquals((int)-2, (int)((Ordered)answer.get(1)).getOrder());
        OrderedComparatorTest.assertEquals((int)0, (int)((Ordered)answer.get(2)).getOrder());
        OrderedComparatorTest.assertEquals((int)50, (int)((Ordered)answer.get(3)).getOrder());
        OrderedComparatorTest.assertEquals((int)200, (int)((Ordered)answer.get(4)).getOrder());
        OrderedComparatorTest.assertEquals((int)Integer.MAX_VALUE, (int)((Ordered)answer.get(5)).getOrder());
    }

    public void testOrderedComparatorLowReverse() throws Exception {
        ArrayList<MyOrder> answer = new ArrayList<MyOrder>();
        answer.add(new MyOrder(0));
        answer.add(new MyOrder(-2));
        answer.add(new MyOrder(200));
        answer.add(new MyOrder(50));
        answer.add(new MyOrder(Integer.MAX_VALUE));
        answer.add(new MyOrder(-4));
        Collections.sort(answer, new OrderedComparator(true));
        OrderedComparatorTest.assertEquals((int)Integer.MAX_VALUE, (int)((Ordered)answer.get(0)).getOrder());
        OrderedComparatorTest.assertEquals((int)200, (int)((Ordered)answer.get(1)).getOrder());
        OrderedComparatorTest.assertEquals((int)50, (int)((Ordered)answer.get(2)).getOrder());
        OrderedComparatorTest.assertEquals((int)0, (int)((Ordered)answer.get(3)).getOrder());
        OrderedComparatorTest.assertEquals((int)-2, (int)((Ordered)answer.get(4)).getOrder());
        OrderedComparatorTest.assertEquals((int)-4, (int)((Ordered)answer.get(5)).getOrder());
    }

    private static final class MyOrder
    implements Ordered {
        private final int order;

        private MyOrder(int order) {
            this.order = order;
        }

        public int getOrder() {
            return this.order;
        }

        public String toString() {
            return "" + this.order;
        }
    }
}

