/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import junit.framework.TestCase;
import org.apache.camel.util.StopWatch;

public class StopWatchTest
extends TestCase {
    public void testStopWatch() throws Exception {
        StopWatch watch = new StopWatch();
        Thread.sleep(200L);
        long taken = watch.stop();
        StopWatchTest.assertEquals((long)taken, (long)watch.taken());
        StopWatchTest.assertTrue((String)("Should take approx 200 millis, was: " + taken), (taken > 150L ? 1 : 0) != 0);
    }

    public void testStopWatchNotStarted() throws Exception {
        StopWatch watch = new StopWatch(false);
        long taken = watch.stop();
        StopWatchTest.assertEquals((long)0L, (long)taken);
        watch.restart();
        Thread.sleep(200L);
        taken = watch.stop();
        StopWatchTest.assertEquals((long)taken, (long)watch.taken());
        StopWatchTest.assertTrue((String)("Should take approx 200 millis, was: " + taken), (taken > 150L ? 1 : 0) != 0);
    }

    public void testStopWatchRestart() throws Exception {
        StopWatch watch = new StopWatch();
        Thread.sleep(200L);
        long taken = watch.stop();
        StopWatchTest.assertEquals((long)taken, (long)watch.taken());
        StopWatchTest.assertTrue((String)("Should take approx 200 millis, was: " + taken), (taken > 150L ? 1 : 0) != 0);
        watch.restart();
        Thread.sleep(100L);
        taken = watch.stop();
        StopWatchTest.assertEquals((long)taken, (long)watch.taken());
        StopWatchTest.assertTrue((String)("Should take approx 100 millis, was: " + taken), (taken > 50L ? 1 : 0) != 0);
    }

    public void testStopWatchTaken() throws Exception {
        StopWatch watch = new StopWatch();
        Thread.sleep(100L);
        long taken = watch.taken();
        Thread.sleep(100L);
        long taken2 = watch.taken();
        StopWatchTest.assertNotSame((Object)taken, (Object)taken2);
        StopWatchTest.assertTrue((taken2 > taken ? 1 : 0) != 0);
    }
}

