/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util.jsse;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.regex.Pattern;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLSocket;
import junit.framework.AssertionFailedError;
import org.apache.camel.CamelContext;
import org.apache.camel.util.jsse.AbstractJsseParametersTest;
import org.apache.camel.util.jsse.CipherSuitesParameters;
import org.apache.camel.util.jsse.ClientAuthentication;
import org.apache.camel.util.jsse.FilterParameters;
import org.apache.camel.util.jsse.KeyManagersParameters;
import org.apache.camel.util.jsse.KeyStoreParameters;
import org.apache.camel.util.jsse.SSLContextClientParameters;
import org.apache.camel.util.jsse.SSLContextParameters;
import org.apache.camel.util.jsse.SSLContextServerParameters;
import org.apache.camel.util.jsse.SecureSocketProtocolsParameters;
import org.apache.camel.util.jsse.TrustManagersParameters;

public class SSLContextParametersTest
extends AbstractJsseParametersTest {
    public void testFilter() {
        SSLContextParameters parameters = new SSLContextParameters();
        Collection result = parameters.filter(null, Arrays.asList("SSLv3", "TLSv1", "TLSv1.1"), Arrays.asList(Pattern.compile("TLS.*")), Arrays.asList(new Pattern[0]));
        SSLContextParametersTest.assertEquals((int)2, (int)result.size());
        this.assertStartsWith(result, "TLS");
        result = parameters.filter(null, Arrays.asList("SSLv3", "TLSv1", "TLSv1.1"), Arrays.asList(Pattern.compile(".*")), Arrays.asList(Pattern.compile("SSL.*")));
        SSLContextParametersTest.assertEquals((int)2, (int)result.size());
        this.assertStartsWith(result, "TLS");
        try {
            this.assertStartsWith((String[])null, "TLS");
            SSLContextParametersTest.fail((String)"We chould got an exception here!");
        }
        catch (AssertionFailedError ex) {
            SSLContextParametersTest.assertEquals((String)"Get a wrong message", (String)"The values should not be null", (String)ex.getMessage());
        }
    }

    public void testPropertyPlaceholders() throws Exception {
        CamelContext camelContext = this.createPropertiesPlaceholderAwareContext();
        KeyStoreParameters ksp = new KeyStoreParameters();
        ksp.setCamelContext(camelContext);
        ksp.setType("{{keyStoreParameters.type}}");
        ksp.setProvider("{{keyStoreParameters.provider}}");
        ksp.setResource("{{keyStoreParameters.resource}}");
        ksp.setPassword("{{keyStoreParamerers.password}}");
        KeyManagersParameters kmp = new KeyManagersParameters();
        kmp.setCamelContext(camelContext);
        kmp.setKeyStore(ksp);
        kmp.setKeyPassword("{{keyManagersParameters.keyPassword}}");
        kmp.setAlgorithm("{{keyManagersParameters.algorithm}}");
        kmp.setProvider("{{keyManagersParameters.provider}}");
        TrustManagersParameters tmp = new TrustManagersParameters();
        tmp.setCamelContext(camelContext);
        tmp.setKeyStore(ksp);
        tmp.setAlgorithm("{{trustManagersParameters.algorithm}}");
        tmp.setProvider("{{trustManagersParameters.provider}}");
        CipherSuitesParameters csp = new CipherSuitesParameters();
        csp.getCipherSuite().add("{{cipherSuite.0}}");
        SecureSocketProtocolsParameters sspp = new SecureSocketProtocolsParameters();
        sspp.getSecureSocketProtocol().add("{{secureSocketProtocol.0}}");
        SSLContextServerParameters scsp = new SSLContextServerParameters();
        scsp.setCamelContext(camelContext);
        scsp.setClientAuthentication("{{sslContextServerParameters.clientAuthentication}}");
        SSLContextParameters scp = new SSLContextParameters();
        scp.setCamelContext(camelContext);
        scp.setKeyManagers(kmp);
        scp.setTrustManagers(tmp);
        scp.setServerParameters(scsp);
        scp.setProvider("{{sslContextParameters.provider}}");
        scp.setSecureSocketProtocol("{{sslContextParameters.protocol}}");
        scp.setSessionTimeout("{{sslContextParameters.sessionTimeout}}");
        scp.setCipherSuites(csp);
        scp.setSecureSocketProtocols(sspp);
        SSLContext context = scp.createSSLContext();
        SSLServerSocket serverSocket = (SSLServerSocket)context.getServerSocketFactory().createServerSocket();
        SSLContextParametersTest.assertTrue((boolean)serverSocket.getNeedClientAuth());
        context.getSocketFactory().createSocket();
        context.createSSLEngine();
    }

    public void testServerParametersClientAuthentication() throws Exception {
        SSLContext controlContext = SSLContext.getInstance("TLS");
        controlContext.init(null, null, null);
        SSLEngine controlEngine = controlContext.createSSLEngine();
        SSLServerSocket controlServerSocket = (SSLServerSocket)controlContext.getServerSocketFactory().createServerSocket();
        SSLContextParameters scp = new SSLContextParameters();
        SSLContextServerParameters scsp = new SSLContextServerParameters();
        scp.setServerParameters(scsp);
        SSLContext context = scp.createSSLContext();
        SSLEngine engine = context.createSSLEngine();
        SSLServerSocket serverSocket = (SSLServerSocket)context.getServerSocketFactory().createServerSocket();
        SSLContextParametersTest.assertEquals((boolean)controlServerSocket.getWantClientAuth(), (boolean)serverSocket.getWantClientAuth());
        SSLContextParametersTest.assertEquals((boolean)controlServerSocket.getNeedClientAuth(), (boolean)serverSocket.getNeedClientAuth());
        SSLContextParametersTest.assertEquals((boolean)controlEngine.getWantClientAuth(), (boolean)engine.getWantClientAuth());
        SSLContextParametersTest.assertEquals((boolean)controlEngine.getNeedClientAuth(), (boolean)engine.getNeedClientAuth());
        scsp.setClientAuthentication(ClientAuthentication.NONE.name());
        context = scp.createSSLContext();
        engine = context.createSSLEngine();
        serverSocket = (SSLServerSocket)context.getServerSocketFactory().createServerSocket();
        SSLContextParametersTest.assertEquals((boolean)false, (boolean)serverSocket.getWantClientAuth());
        SSLContextParametersTest.assertEquals((boolean)false, (boolean)serverSocket.getNeedClientAuth());
        SSLContextParametersTest.assertEquals((boolean)false, (boolean)engine.getWantClientAuth());
        SSLContextParametersTest.assertEquals((boolean)false, (boolean)engine.getNeedClientAuth());
        scsp.setClientAuthentication(ClientAuthentication.WANT.name());
        context = scp.createSSLContext();
        engine = context.createSSLEngine();
        serverSocket = (SSLServerSocket)context.getServerSocketFactory().createServerSocket();
        SSLContextParametersTest.assertEquals((boolean)true, (boolean)serverSocket.getWantClientAuth());
        SSLContextParametersTest.assertEquals((boolean)false, (boolean)serverSocket.getNeedClientAuth());
        SSLContextParametersTest.assertEquals((boolean)true, (boolean)engine.getWantClientAuth());
        SSLContextParametersTest.assertEquals((boolean)false, (boolean)engine.getNeedClientAuth());
        scsp.setClientAuthentication(ClientAuthentication.REQUIRE.name());
        context = scp.createSSLContext();
        engine = context.createSSLEngine();
        serverSocket = (SSLServerSocket)context.getServerSocketFactory().createServerSocket();
        SSLContextParametersTest.assertEquals((boolean)false, (boolean)serverSocket.getWantClientAuth());
        SSLContextParametersTest.assertEquals((boolean)true, (boolean)serverSocket.getNeedClientAuth());
        SSLContextParametersTest.assertEquals((boolean)false, (boolean)engine.getWantClientAuth());
        SSLContextParametersTest.assertEquals((boolean)true, (boolean)engine.getNeedClientAuth());
    }

    public void testServerParameters() throws Exception {
        SSLContext controlContext = SSLContext.getInstance("TLS");
        controlContext.init(null, null, null);
        SSLEngine controlEngine = controlContext.createSSLEngine();
        SSLSocket controlSocket = (SSLSocket)controlContext.getSocketFactory().createSocket();
        SSLServerSocket controlServerSocket = (SSLServerSocket)controlContext.getServerSocketFactory().createServerSocket();
        SSLContextParameters scp = new SSLContextParameters();
        SSLContextServerParameters scsp = new SSLContextServerParameters();
        scp.setServerParameters(scsp);
        SSLContext context = scp.createSSLContext();
        SSLEngine engine = context.createSSLEngine();
        SSLSocket socket = (SSLSocket)context.getSocketFactory().createSocket();
        SSLServerSocket serverSocket = (SSLServerSocket)context.getServerSocketFactory().createServerSocket();
        SSLContextParametersTest.assertTrue((boolean)Arrays.equals(controlEngine.getEnabledCipherSuites(), engine.getEnabledCipherSuites()));
        SSLContextParametersTest.assertTrue((boolean)Arrays.equals(controlSocket.getEnabledCipherSuites(), socket.getEnabledCipherSuites()));
        SSLContextParametersTest.assertTrue((boolean)Arrays.equals(this.getDefaultCipherSuiteIncludes(controlServerSocket.getSupportedCipherSuites()), serverSocket.getEnabledCipherSuites()));
        SSLContextParametersTest.assertEquals((boolean)controlServerSocket.getWantClientAuth(), (boolean)serverSocket.getWantClientAuth());
        SSLContextParametersTest.assertEquals((boolean)controlServerSocket.getNeedClientAuth(), (boolean)serverSocket.getNeedClientAuth());
        scp.setCipherSuites(new CipherSuitesParameters());
        context = scp.createSSLContext();
        engine = context.createSSLEngine();
        socket = (SSLSocket)context.getSocketFactory().createSocket();
        serverSocket = (SSLServerSocket)context.getServerSocketFactory().createServerSocket();
        SSLContextParametersTest.assertEquals((int)0, (int)engine.getEnabledCipherSuites().length);
        SSLContextParametersTest.assertEquals((int)0, (int)socket.getEnabledCipherSuites().length);
        SSLContextParametersTest.assertEquals((int)0, (int)serverSocket.getEnabledCipherSuites().length);
        scp.setCipherSuites(null);
        CipherSuitesParameters csp = new CipherSuitesParameters();
        scsp.setCipherSuites(csp);
        context = scp.createSSLContext();
        engine = context.createSSLEngine();
        socket = (SSLSocket)context.getSocketFactory().createSocket();
        serverSocket = (SSLServerSocket)context.getServerSocketFactory().createServerSocket();
        SSLContextParametersTest.assertTrue((boolean)Arrays.equals(controlEngine.getEnabledCipherSuites(), engine.getEnabledCipherSuites()));
        SSLContextParametersTest.assertTrue((boolean)Arrays.equals(controlSocket.getEnabledCipherSuites(), socket.getEnabledCipherSuites()));
        SSLContextParametersTest.assertEquals((int)0, (int)serverSocket.getEnabledCipherSuites().length);
        FilterParameters filter = new FilterParameters();
        filter.getExclude().add(".*");
        scsp.setCipherSuites(null);
        scsp.setCipherSuitesFilter(filter);
        context = scp.createSSLContext();
        engine = context.createSSLEngine();
        socket = (SSLSocket)context.getSocketFactory().createSocket();
        serverSocket = (SSLServerSocket)context.getServerSocketFactory().createServerSocket();
        SSLContextParametersTest.assertTrue((boolean)Arrays.equals(controlEngine.getEnabledCipherSuites(), engine.getEnabledCipherSuites()));
        SSLContextParametersTest.assertTrue((boolean)Arrays.equals(controlSocket.getEnabledCipherSuites(), socket.getEnabledCipherSuites()));
        SSLContextParametersTest.assertEquals((int)0, (int)serverSocket.getEnabledCipherSuites().length);
        filter.getInclude().add(".*");
        filter.getExclude().clear();
        scsp.setCipherSuites(csp);
        context = scp.createSSLContext();
        engine = context.createSSLEngine();
        socket = (SSLSocket)context.getSocketFactory().createSocket();
        serverSocket = (SSLServerSocket)context.getServerSocketFactory().createServerSocket();
        SSLContextParametersTest.assertTrue((boolean)Arrays.equals(controlEngine.getEnabledCipherSuites(), engine.getEnabledCipherSuites()));
        SSLContextParametersTest.assertTrue((boolean)Arrays.equals(controlSocket.getEnabledCipherSuites(), socket.getEnabledCipherSuites()));
        SSLContextParametersTest.assertEquals((int)0, (int)serverSocket.getEnabledCipherSuites().length);
        SecureSocketProtocolsParameters sspp = new SecureSocketProtocolsParameters();
        scsp.setSecureSocketProtocols(sspp);
        context = scp.createSSLContext();
        engine = context.createSSLEngine();
        socket = (SSLSocket)context.getSocketFactory().createSocket();
        serverSocket = (SSLServerSocket)context.getServerSocketFactory().createServerSocket();
        SSLContextParametersTest.assertFalse((boolean)Arrays.equals(controlEngine.getEnabledProtocols(), engine.getEnabledProtocols()));
        SSLContextParametersTest.assertFalse((boolean)Arrays.equals(controlSocket.getEnabledProtocols(), socket.getEnabledProtocols()));
        SSLContextParametersTest.assertEquals((int)0, (int)serverSocket.getEnabledProtocols().length);
        filter = new FilterParameters();
        filter.getExclude().add(".*");
        scsp.setSecureSocketProtocols(null);
        scsp.setSecureSocketProtocolsFilter(filter);
        engine = context.createSSLEngine();
        socket = (SSLSocket)context.getSocketFactory().createSocket();
        serverSocket = (SSLServerSocket)context.getServerSocketFactory().createServerSocket();
        this.assertStartsWith(engine.getEnabledProtocols(), "TLS");
        this.assertStartsWith(socket.getEnabledProtocols(), "TLS");
        SSLContextParametersTest.assertEquals((int)0, (int)serverSocket.getEnabledProtocols().length);
        filter.getInclude().add(".*");
        filter.getExclude().clear();
        scsp.setSecureSocketProtocols(sspp);
        context = scp.createSSLContext();
        engine = context.createSSLEngine();
        socket = (SSLSocket)context.getSocketFactory().createSocket();
        serverSocket = (SSLServerSocket)context.getServerSocketFactory().createServerSocket();
        this.assertStartsWith(engine.getEnabledProtocols(), "TLS");
        this.assertStartsWith(socket.getEnabledProtocols(), "TLS");
        SSLContextParametersTest.assertEquals((int)0, (int)serverSocket.getEnabledProtocols().length);
        scsp.setSessionTimeout("12345");
        context = scp.createSSLContext();
        engine = context.createSSLEngine();
        socket = (SSLSocket)context.getSocketFactory().createSocket();
        serverSocket = (SSLServerSocket)context.getServerSocketFactory().createServerSocket();
        SSLContextParametersTest.assertEquals((int)controlContext.getClientSessionContext().getSessionTimeout(), (int)context.getClientSessionContext().getSessionTimeout());
        SSLContextParametersTest.assertEquals((int)12345, (int)context.getServerSessionContext().getSessionTimeout());
    }

    private void checkProtocols(String[] control, String[] configured) {
        SSLContextParametersTest.assertTrue((boolean)Arrays.asList(configured).containsAll(Arrays.asList(control)));
    }

    public void testClientParameters() throws Exception {
        SSLContext controlContext = SSLContext.getInstance("TLS");
        controlContext.init(null, null, null);
        SSLEngine controlEngine = controlContext.createSSLEngine();
        SSLSocket controlSocket = (SSLSocket)controlContext.getSocketFactory().createSocket();
        SSLServerSocket controlServerSocket = (SSLServerSocket)controlContext.getServerSocketFactory().createServerSocket();
        SSLContextParameters scp = new SSLContextParameters();
        SSLContextClientParameters sccp = new SSLContextClientParameters();
        scp.setClientParameters(sccp);
        SSLContext context = scp.createSSLContext();
        SSLEngine engine = context.createSSLEngine();
        SSLSocket socket = (SSLSocket)context.getSocketFactory().createSocket();
        SSLServerSocket serverSocket = (SSLServerSocket)context.getServerSocketFactory().createServerSocket();
        SSLContextParametersTest.assertTrue((boolean)Arrays.equals(controlEngine.getEnabledCipherSuites(), engine.getEnabledCipherSuites()));
        SSLContextParametersTest.assertTrue((boolean)Arrays.equals(controlSocket.getEnabledCipherSuites(), socket.getEnabledCipherSuites()));
        SSLContextParametersTest.assertTrue((boolean)Arrays.equals(this.getDefaultCipherSuiteIncludes(controlServerSocket.getSupportedCipherSuites()), serverSocket.getEnabledCipherSuites()));
        scp.setCipherSuites(new CipherSuitesParameters());
        context = scp.createSSLContext();
        engine = context.createSSLEngine();
        socket = (SSLSocket)context.getSocketFactory().createSocket();
        serverSocket = (SSLServerSocket)context.getServerSocketFactory().createServerSocket();
        SSLContextParametersTest.assertEquals((int)0, (int)socket.getEnabledCipherSuites().length);
        scp.setCipherSuites(null);
        CipherSuitesParameters csp = new CipherSuitesParameters();
        sccp.setCipherSuites(csp);
        context = scp.createSSLContext();
        engine = context.createSSLEngine();
        socket = (SSLSocket)context.getSocketFactory().createSocket();
        serverSocket = (SSLServerSocket)context.getServerSocketFactory().createServerSocket();
        SSLContextParametersTest.assertTrue((boolean)Arrays.equals(controlEngine.getEnabledCipherSuites(), engine.getEnabledCipherSuites()));
        SSLContextParametersTest.assertEquals((int)0, (int)socket.getEnabledCipherSuites().length);
        SSLContextParametersTest.assertTrue((boolean)Arrays.equals(this.getDefaultCipherSuiteIncludes(controlServerSocket.getSupportedCipherSuites()), serverSocket.getEnabledCipherSuites()));
        FilterParameters filter = new FilterParameters();
        filter.getExclude().add(".*");
        sccp.setCipherSuites(null);
        sccp.setCipherSuitesFilter(filter);
        context = scp.createSSLContext();
        engine = context.createSSLEngine();
        socket = (SSLSocket)context.getSocketFactory().createSocket();
        serverSocket = (SSLServerSocket)context.getServerSocketFactory().createServerSocket();
        SSLContextParametersTest.assertTrue((boolean)Arrays.equals(controlEngine.getEnabledCipherSuites(), engine.getEnabledCipherSuites()));
        SSLContextParametersTest.assertEquals((int)0, (int)socket.getEnabledCipherSuites().length);
        SSLContextParametersTest.assertTrue((boolean)Arrays.equals(this.getDefaultCipherSuiteIncludes(controlServerSocket.getSupportedCipherSuites()), serverSocket.getEnabledCipherSuites()));
        filter.getInclude().add(".*");
        filter.getExclude().clear();
        sccp.setCipherSuites(csp);
        context = scp.createSSLContext();
        engine = context.createSSLEngine();
        socket = (SSLSocket)context.getSocketFactory().createSocket();
        serverSocket = (SSLServerSocket)context.getServerSocketFactory().createServerSocket();
        SSLContextParametersTest.assertTrue((boolean)Arrays.equals(controlEngine.getEnabledCipherSuites(), engine.getEnabledCipherSuites()));
        SSLContextParametersTest.assertEquals((int)0, (int)socket.getEnabledCipherSuites().length);
        SSLContextParametersTest.assertTrue((boolean)Arrays.equals(this.getDefaultCipherSuiteIncludes(controlServerSocket.getSupportedCipherSuites()), serverSocket.getEnabledCipherSuites()));
        SecureSocketProtocolsParameters sspp = new SecureSocketProtocolsParameters();
        sccp.setSecureSocketProtocols(sspp);
        context = scp.createSSLContext();
        engine = context.createSSLEngine();
        socket = (SSLSocket)context.getSocketFactory().createSocket();
        serverSocket = (SSLServerSocket)context.getServerSocketFactory().createServerSocket();
        this.assertStartsWith(engine.getEnabledProtocols(), "TLS");
        SSLContextParametersTest.assertEquals((int)0, (int)socket.getEnabledProtocols().length);
        this.assertStartsWith(serverSocket.getEnabledProtocols(), "TLS");
        filter = new FilterParameters();
        filter.getExclude().add(".*");
        sccp.setSecureSocketProtocols(null);
        sccp.setSecureSocketProtocolsFilter(filter);
        engine = context.createSSLEngine();
        socket = (SSLSocket)context.getSocketFactory().createSocket();
        serverSocket = (SSLServerSocket)context.getServerSocketFactory().createServerSocket();
        this.assertStartsWith(engine.getEnabledProtocols(), "TLS");
        SSLContextParametersTest.assertEquals((int)0, (int)socket.getEnabledProtocols().length);
        this.assertStartsWith(serverSocket.getEnabledProtocols(), "TLS");
        filter.getInclude().add(".*");
        filter.getExclude().clear();
        sccp.setSecureSocketProtocols(sspp);
        context = scp.createSSLContext();
        engine = context.createSSLEngine();
        socket = (SSLSocket)context.getSocketFactory().createSocket();
        serverSocket = (SSLServerSocket)context.getServerSocketFactory().createServerSocket();
        this.assertStartsWith(engine.getEnabledProtocols(), "TLS");
        SSLContextParametersTest.assertEquals((int)0, (int)socket.getEnabledProtocols().length);
        this.assertStartsWith(serverSocket.getEnabledProtocols(), "TLS");
        sccp.setSessionTimeout("12345");
        context = scp.createSSLContext();
        engine = context.createSSLEngine();
        socket = (SSLSocket)context.getSocketFactory().createSocket();
        serverSocket = (SSLServerSocket)context.getServerSocketFactory().createServerSocket();
        SSLContextParametersTest.assertEquals((int)controlContext.getServerSessionContext().getSessionTimeout(), (int)context.getServerSessionContext().getSessionTimeout());
        SSLContextParametersTest.assertEquals((int)12345, (int)context.getClientSessionContext().getSessionTimeout());
    }

    public void testCipherSuites() throws Exception {
        SSLContext controlContext = SSLContext.getInstance("TLS");
        controlContext.init(null, null, null);
        SSLEngine controlEngine = controlContext.createSSLEngine();
        SSLSocket controlSocket = (SSLSocket)controlContext.getSocketFactory().createSocket();
        SSLServerSocket controlServerSocket = (SSLServerSocket)controlContext.getServerSocketFactory().createServerSocket();
        SSLContextParameters scp = new SSLContextParameters();
        SSLContext context = scp.createSSLContext();
        SSLEngine engine = context.createSSLEngine();
        SSLSocket socket = (SSLSocket)context.getSocketFactory().createSocket();
        SSLServerSocket serverSocket = (SSLServerSocket)context.getServerSocketFactory().createServerSocket();
        SSLContextParametersTest.assertTrue((boolean)Arrays.equals(controlEngine.getEnabledCipherSuites(), engine.getEnabledCipherSuites()));
        SSLContextParametersTest.assertTrue((boolean)Arrays.equals(controlSocket.getEnabledCipherSuites(), socket.getEnabledCipherSuites()));
        SSLContextParametersTest.assertTrue((boolean)Arrays.equals(this.getDefaultCipherSuiteIncludes(controlServerSocket.getSupportedCipherSuites()), serverSocket.getEnabledCipherSuites()));
        CipherSuitesParameters csp = new CipherSuitesParameters();
        scp.setCipherSuites(csp);
        context = scp.createSSLContext();
        engine = context.createSSLEngine();
        socket = (SSLSocket)context.getSocketFactory().createSocket();
        serverSocket = (SSLServerSocket)context.getServerSocketFactory().createServerSocket();
        SSLContextParametersTest.assertEquals((int)0, (int)engine.getEnabledCipherSuites().length);
        SSLContextParametersTest.assertEquals((int)0, (int)socket.getEnabledCipherSuites().length);
        SSLContextParametersTest.assertEquals((int)0, (int)serverSocket.getEnabledCipherSuites().length);
        csp.getCipherSuite().add(controlEngine.getEnabledCipherSuites()[0]);
        context = scp.createSSLContext();
        engine = context.createSSLEngine();
        socket = (SSLSocket)context.getSocketFactory().createSocket();
        serverSocket = (SSLServerSocket)context.getServerSocketFactory().createServerSocket();
        SSLContextParametersTest.assertEquals((int)1, (int)engine.getEnabledCipherSuites().length);
        SSLContextParametersTest.assertEquals((String)controlEngine.getEnabledCipherSuites()[0], (String)engine.getEnabledCipherSuites()[0]);
        SSLContextParametersTest.assertEquals((int)1, (int)socket.getEnabledCipherSuites().length);
        SSLContextParametersTest.assertEquals((String)controlEngine.getEnabledCipherSuites()[0], (String)socket.getEnabledCipherSuites()[0]);
        SSLContextParametersTest.assertEquals((int)1, (int)serverSocket.getEnabledCipherSuites().length);
        SSLContextParametersTest.assertEquals((String)controlEngine.getEnabledCipherSuites()[0], (String)serverSocket.getEnabledCipherSuites()[0]);
        FilterParameters filter = new FilterParameters();
        filter.getInclude().add(".*");
        scp.setCipherSuitesFilter(filter);
        context = scp.createSSLContext();
        engine = context.createSSLEngine();
        socket = (SSLSocket)context.getSocketFactory().createSocket();
        serverSocket = (SSLServerSocket)context.getServerSocketFactory().createServerSocket();
        SSLContextParametersTest.assertEquals((int)1, (int)engine.getEnabledCipherSuites().length);
        SSLContextParametersTest.assertEquals((String)controlEngine.getEnabledCipherSuites()[0], (String)engine.getEnabledCipherSuites()[0]);
        SSLContextParametersTest.assertEquals((int)1, (int)socket.getEnabledCipherSuites().length);
        SSLContextParametersTest.assertEquals((String)controlEngine.getEnabledCipherSuites()[0], (String)socket.getEnabledCipherSuites()[0]);
        SSLContextParametersTest.assertEquals((int)1, (int)socket.getEnabledCipherSuites().length);
        SSLContextParametersTest.assertEquals((String)controlEngine.getEnabledCipherSuites()[0], (String)serverSocket.getEnabledCipherSuites()[0]);
    }

    public void testCipherSuitesFilter() throws Exception {
        SSLContext controlContext = SSLContext.getInstance("TLS");
        controlContext.init(null, null, null);
        SSLEngine controlEngine = controlContext.createSSLEngine();
        SSLSocket controlSocket = (SSLSocket)controlContext.getSocketFactory().createSocket();
        SSLServerSocket controlServerSocket = (SSLServerSocket)controlContext.getServerSocketFactory().createServerSocket();
        SSLContextParameters scp = new SSLContextParameters();
        SSLContext context = scp.createSSLContext();
        CipherSuitesParameters csp = new CipherSuitesParameters();
        scp.setCipherSuites(csp);
        SSLEngine engine = context.createSSLEngine();
        SSLSocket socket = (SSLSocket)context.getSocketFactory().createSocket();
        SSLServerSocket serverSocket = (SSLServerSocket)context.getServerSocketFactory().createServerSocket();
        SSLContextParametersTest.assertTrue((boolean)Arrays.equals(controlEngine.getEnabledCipherSuites(), engine.getEnabledCipherSuites()));
        SSLContextParametersTest.assertTrue((boolean)Arrays.equals(controlSocket.getEnabledCipherSuites(), socket.getEnabledCipherSuites()));
        SSLContextParametersTest.assertTrue((boolean)Arrays.equals(this.getDefaultCipherSuiteIncludes(controlServerSocket.getSupportedCipherSuites()), serverSocket.getEnabledCipherSuites()));
        FilterParameters filter = new FilterParameters();
        scp.setCipherSuitesFilter(filter);
        context = scp.createSSLContext();
        engine = context.createSSLEngine();
        socket = (SSLSocket)context.getSocketFactory().createSocket();
        serverSocket = (SSLServerSocket)context.getServerSocketFactory().createServerSocket();
        SSLContextParametersTest.assertEquals((int)0, (int)engine.getEnabledCipherSuites().length);
        SSLContextParametersTest.assertEquals((int)0, (int)socket.getEnabledCipherSuites().length);
        SSLContextParametersTest.assertEquals((int)0, (int)serverSocket.getEnabledCipherSuites().length);
        filter.getInclude().add(".*");
        context = scp.createSSLContext();
        engine = context.createSSLEngine();
        socket = (SSLSocket)context.getSocketFactory().createSocket();
        serverSocket = (SSLServerSocket)context.getServerSocketFactory().createServerSocket();
        SSLContextParametersTest.assertEquals((int)0, (int)engine.getEnabledCipherSuites().length);
        SSLContextParametersTest.assertEquals((int)0, (int)socket.getEnabledCipherSuites().length);
        SSLContextParametersTest.assertEquals((int)0, (int)serverSocket.getEnabledCipherSuites().length);
        filter.getExclude().add(".*");
        context = scp.createSSLContext();
        engine = context.createSSLEngine();
        socket = (SSLSocket)context.getSocketFactory().createSocket();
        serverSocket = (SSLServerSocket)context.getServerSocketFactory().createServerSocket();
        SSLContextParametersTest.assertEquals((int)0, (int)engine.getEnabledCipherSuites().length);
        SSLContextParametersTest.assertEquals((int)0, (int)socket.getEnabledCipherSuites().length);
        SSLContextParametersTest.assertEquals((int)0, (int)serverSocket.getEnabledCipherSuites().length);
        filter.getInclude().clear();
        filter.getExclude().clear();
        csp.getCipherSuite().add("TLS_RSA_WITH_AES_128_CBC_SHA");
        filter.getInclude().add("TLS.*");
        context = scp.createSSLContext();
        engine = context.createSSLEngine();
        socket = (SSLSocket)context.getSocketFactory().createSocket();
        serverSocket = (SSLServerSocket)context.getServerSocketFactory().createServerSocket();
        if (!SSLContextParametersTest.isPlatform("aix")) {
            SSLContextParametersTest.assertTrue((engine.getEnabledCipherSuites().length >= 1 ? 1 : 0) != 0);
            this.assertStartsWith(engine.getEnabledCipherSuites(), "TLS");
            SSLContextParametersTest.assertTrue((socket.getEnabledCipherSuites().length >= 1 ? 1 : 0) != 0);
            this.assertStartsWith(socket.getEnabledCipherSuites(), "TLS");
            SSLContextParametersTest.assertTrue((serverSocket.getEnabledCipherSuites().length >= 1 ? 1 : 0) != 0);
            this.assertStartsWith(serverSocket.getEnabledCipherSuites(), "TLS");
        }
    }

    public void testSecureSocketProtocols() throws Exception {
        SSLContext controlContext = SSLContext.getInstance("TLS");
        controlContext.init(null, null, null);
        SSLEngine controlEngine = controlContext.createSSLEngine();
        SSLSocket controlSocket = (SSLSocket)controlContext.getSocketFactory().createSocket();
        SSLServerSocket controlServerSocket = (SSLServerSocket)controlContext.getServerSocketFactory().createServerSocket();
        SSLContextParameters scp = new SSLContextParameters();
        SSLContext context = scp.createSSLContext();
        SSLEngine engine = context.createSSLEngine();
        SSLSocket socket = (SSLSocket)context.getSocketFactory().createSocket();
        SSLServerSocket serverSocket = (SSLServerSocket)context.getServerSocketFactory().createServerSocket();
        this.assertStartsWith(engine.getEnabledProtocols(), "TLS");
        this.assertStartsWith(socket.getEnabledProtocols(), "TLS");
        this.assertStartsWith(serverSocket.getEnabledProtocols(), "TLS");
        SecureSocketProtocolsParameters sspp = new SecureSocketProtocolsParameters();
        scp.setSecureSocketProtocols(sspp);
        context = scp.createSSLContext();
        engine = context.createSSLEngine();
        socket = (SSLSocket)context.getSocketFactory().createSocket();
        serverSocket = (SSLServerSocket)context.getServerSocketFactory().createServerSocket();
        SSLContextParametersTest.assertEquals((int)0, (int)engine.getEnabledProtocols().length);
        SSLContextParametersTest.assertEquals((int)0, (int)socket.getEnabledProtocols().length);
        SSLContextParametersTest.assertEquals((int)0, (int)serverSocket.getEnabledProtocols().length);
        sspp.getSecureSocketProtocol().add("TLSv1");
        context = scp.createSSLContext();
        engine = context.createSSLEngine();
        socket = (SSLSocket)context.getSocketFactory().createSocket();
        serverSocket = (SSLServerSocket)context.getServerSocketFactory().createServerSocket();
        SSLContextParametersTest.assertEquals((int)1, (int)engine.getEnabledProtocols().length);
        SSLContextParametersTest.assertEquals((String)"TLSv1", (String)engine.getEnabledProtocols()[0]);
        SSLContextParametersTest.assertEquals((int)1, (int)socket.getEnabledProtocols().length);
        SSLContextParametersTest.assertEquals((String)"TLSv1", (String)socket.getEnabledProtocols()[0]);
        SSLContextParametersTest.assertEquals((int)1, (int)serverSocket.getEnabledProtocols().length);
        SSLContextParametersTest.assertEquals((String)"TLSv1", (String)serverSocket.getEnabledProtocols()[0]);
        FilterParameters filter = new FilterParameters();
        filter.getInclude().add(".*");
        scp.setSecureSocketProtocolsFilter(filter);
        context = scp.createSSLContext();
        engine = context.createSSLEngine();
        socket = (SSLSocket)context.getSocketFactory().createSocket();
        serverSocket = (SSLServerSocket)context.getServerSocketFactory().createServerSocket();
        if (!SSLContextParametersTest.isPlatform("aix")) {
            SSLContextParametersTest.assertEquals((int)1, (int)engine.getEnabledProtocols().length);
            SSLContextParametersTest.assertEquals((String)"TLSv1", (String)engine.getEnabledProtocols()[0]);
            SSLContextParametersTest.assertEquals((int)1, (int)socket.getEnabledProtocols().length);
            SSLContextParametersTest.assertEquals((String)"TLSv1", (String)socket.getEnabledProtocols()[0]);
            SSLContextParametersTest.assertEquals((int)1, (int)socket.getEnabledProtocols().length);
            SSLContextParametersTest.assertEquals((String)"TLSv1", (String)serverSocket.getEnabledProtocols()[0]);
        }
    }

    public void testSecureSocketProtocolsFilter() throws Exception {
        SSLContext controlContext = SSLContext.getInstance("TLS");
        controlContext.init(null, null, null);
        SSLEngine controlEngine = controlContext.createSSLEngine();
        SSLSocket controlSocket = (SSLSocket)controlContext.getSocketFactory().createSocket();
        SSLServerSocket controlServerSocket = (SSLServerSocket)controlContext.getServerSocketFactory().createServerSocket();
        SSLContextParameters scp = new SSLContextParameters();
        SSLContext context = scp.createSSLContext();
        SSLEngine engine = context.createSSLEngine();
        SSLSocket socket = (SSLSocket)context.getSocketFactory().createSocket();
        SSLServerSocket serverSocket = (SSLServerSocket)context.getServerSocketFactory().createServerSocket();
        this.assertStartsWith(engine.getEnabledProtocols(), "TLS");
        this.assertStartsWith(socket.getEnabledProtocols(), "TLS");
        this.assertStartsWith(serverSocket.getEnabledProtocols(), "TLS");
        FilterParameters filter = new FilterParameters();
        scp.setSecureSocketProtocolsFilter(filter);
        context = scp.createSSLContext();
        engine = context.createSSLEngine();
        socket = (SSLSocket)context.getSocketFactory().createSocket();
        serverSocket = (SSLServerSocket)context.getServerSocketFactory().createServerSocket();
        SSLContextParametersTest.assertEquals((int)0, (int)engine.getEnabledProtocols().length);
        SSLContextParametersTest.assertEquals((int)0, (int)socket.getEnabledProtocols().length);
        SSLContextParametersTest.assertEquals((int)0, (int)serverSocket.getEnabledProtocols().length);
        filter.getInclude().add(".*");
        context = scp.createSSLContext();
        engine = context.createSSLEngine();
        socket = (SSLSocket)context.getSocketFactory().createSocket();
        serverSocket = (SSLServerSocket)context.getServerSocketFactory().createServerSocket();
        SSLContextParametersTest.assertTrue((boolean)Arrays.equals(controlEngine.getEnabledProtocols(), engine.getEnabledProtocols()));
        SSLContextParametersTest.assertTrue((boolean)Arrays.equals(controlSocket.getEnabledProtocols(), socket.getEnabledProtocols()));
        this.checkProtocols(controlServerSocket.getEnabledProtocols(), serverSocket.getEnabledProtocols());
        filter.getExclude().add(".*");
        context = scp.createSSLContext();
        engine = context.createSSLEngine();
        socket = (SSLSocket)context.getSocketFactory().createSocket();
        serverSocket = (SSLServerSocket)context.getServerSocketFactory().createServerSocket();
        SSLContextParametersTest.assertEquals((int)0, (int)engine.getEnabledProtocols().length);
        SSLContextParametersTest.assertEquals((int)0, (int)socket.getEnabledProtocols().length);
        SSLContextParametersTest.assertEquals((int)0, (int)serverSocket.getEnabledProtocols().length);
        filter.getInclude().clear();
        filter.getExclude().clear();
        filter.getInclude().add("TLS.*");
        context = scp.createSSLContext();
        engine = context.createSSLEngine();
        socket = (SSLSocket)context.getSocketFactory().createSocket();
        serverSocket = (SSLServerSocket)context.getServerSocketFactory().createServerSocket();
        if (!SSLContextParametersTest.isPlatform("aix")) {
            SSLContextParametersTest.assertTrue((engine.getEnabledProtocols().length >= 1 ? 1 : 0) != 0);
            this.assertStartsWith(engine.getEnabledProtocols(), "TLS");
            SSLContextParametersTest.assertTrue((socket.getEnabledProtocols().length >= 1 ? 1 : 0) != 0);
            this.assertStartsWith(socket.getEnabledProtocols(), "TLS");
            SSLContextParametersTest.assertTrue((socket.getEnabledProtocols().length >= 1 ? 1 : 0) != 0);
            this.assertStartsWith(serverSocket.getEnabledProtocols(), "TLS");
        }
    }

    public void testSessionTimeout() throws Exception {
        SSLContextParameters scp = new SSLContextParameters();
        scp.setSessionTimeout("60");
        SSLContext context = scp.createSSLContext();
        SSLContextParametersTest.assertEquals((int)60, (int)context.getClientSessionContext().getSessionTimeout());
        SSLContextParametersTest.assertEquals((int)60, (int)context.getServerSessionContext().getSessionTimeout());
        scp.setSessionTimeout("0");
        context = scp.createSSLContext();
        SSLContextParametersTest.assertEquals((int)0, (int)context.getClientSessionContext().getSessionTimeout());
        SSLContextParametersTest.assertEquals((int)0, (int)context.getServerSessionContext().getSessionTimeout());
    }

    public void testDefaultSecureSocketProtocol() throws Exception {
        SSLContextParameters scp = new SSLContextParameters();
        SSLContext context = scp.createSSLContext();
        SSLContextParametersTest.assertEquals((String)"TLS", (String)context.getProtocol());
    }

    public void testSecureSocketProtocol() throws Exception {
        SSLContextParameters scp = new SSLContextParameters();
        scp.setSecureSocketProtocol("SSLv3");
        SSLContext context = scp.createSSLContext();
        SSLContextParametersTest.assertEquals((String)"SSLv3", (String)context.getProtocol());
    }

    public void testProvider() throws Exception {
        SSLContextParameters scp = new SSLContextParameters();
        scp.createSSLContext();
        SSLContext context = scp.createSSLContext();
        SSLContext defaultContext = SSLContext.getDefault();
        SSLContextParametersTest.assertEquals((String)defaultContext.getProvider().getName(), (String)context.getProvider().getName());
    }

    protected String[] getDefaultCipherSuiteIncludes(String[] availableCipherSuites) {
        LinkedList<String> enabled = new LinkedList<String>();
        for (String string : availableCipherSuites) {
            if (string.contains("_anon_") || string.contains("_NULL_")) continue;
            enabled.add(string);
        }
        return enabled.toArray(new String[enabled.size()]);
    }

    protected void assertStartsWith(String[] values, String prefix) {
        SSLContextParametersTest.assertNotNull((String)"The values should not be null", (Object)values);
        for (String value : values) {
            SSLContextParametersTest.assertTrue((String)(value + " does not start with the prefix " + prefix), (boolean)value.startsWith(prefix));
        }
    }

    protected void assertStartsWith(Collection<String> values, String prefix) {
        SSLContextParametersTest.assertNotNull((String)"The values should not be null", values);
        for (String value : values) {
            SSLContextParametersTest.assertTrue((String)(value + " does not start with the prefix " + prefix), (boolean)value.startsWith(prefix));
        }
    }
}

