/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util.jsse;

import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import org.apache.camel.CamelContext;
import org.apache.camel.util.jsse.AbstractJsseParametersTest;
import org.apache.camel.util.jsse.SecureRandomParameters;

public class SecureRandomParametersTest
extends AbstractJsseParametersTest {
    public void testPropertyPlaceholders() throws Exception {
        if (this.canTest()) {
            CamelContext context = this.createPropertiesPlaceholderAwareContext();
            SecureRandomParameters srp = new SecureRandomParameters();
            srp.setCamelContext(context);
            srp.setAlgorithm("{{secureRandomParameters.algorithm}}");
            srp.setProvider("{{secureRandomParameters.provider}}");
            srp.createSecureRandom();
        }
    }

    public void testCreateSecureRandom() throws Exception {
        if (this.canTest()) {
            SecureRandomParameters srp = new SecureRandomParameters();
            srp.setAlgorithm("SHA1PRNG");
            SecureRandom sr = srp.createSecureRandom();
            SecureRandomParametersTest.assertEquals((String)"SHA1PRNG", (String)sr.getAlgorithm());
            String providerName = sr.getProvider().getName();
            srp.setProvider(providerName);
            sr = srp.createSecureRandom();
            SecureRandomParametersTest.assertEquals((String)"SHA1PRNG", (String)sr.getAlgorithm());
            SecureRandomParametersTest.assertEquals((String)providerName, (String)sr.getProvider().getName());
        }
    }

    public void testExplicitInvalidAlgorithm() throws Exception {
        SecureRandomParameters srp = new SecureRandomParameters();
        srp.setAlgorithm("fsafsadfasdfasdf");
        try {
            srp.createSecureRandom();
            SecureRandomParametersTest.fail();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
    }

    public void testExplicitInvalidProvider() throws Exception {
        if (this.canTest()) {
            SecureRandomParameters srp = new SecureRandomParameters();
            srp.setAlgorithm("SHA1PRNG");
            srp.setProvider("asdfsadfasdfasdf");
            try {
                srp.createSecureRandom();
                SecureRandomParametersTest.fail();
            }
            catch (NoSuchProviderException noSuchProviderException) {
                // empty catch block
            }
        }
    }

    protected boolean canTest() {
        try {
            SecureRandom.getInstance("SHA1PRNG");
            return true;
        }
        catch (NoSuchAlgorithmException e) {
            return false;
        }
    }
}

