/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xmlsecurity;

import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.security.Provider;
import java.security.Security;
import org.apache.jcp.xml.dsig.internal.dom.XMLDSigRI;
import org.apache.xml.security.Init;
import org.apache.xml.security.utils.XMLUtils;

public final class SantuarioUtil {
    private SantuarioUtil() {
    }

    public static void initializeSantuario() {
        boolean wasSet = false;
        try {
            wasSet = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    String lineBreakPropName = "org.apache.xml.security.ignoreLineBreaks";
                    if (System.getProperty(lineBreakPropName) == null) {
                        System.setProperty(lineBreakPropName, "true");
                        return false;
                    }
                    return true;
                }
            });
        }
        catch (Throwable t) {
            // empty catch block
        }
        Init.init();
        if (!wasSet) {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Boolean>(){

                    @Override
                    public Boolean run() throws Exception {
                        Field f = XMLUtils.class.getDeclaredField("ignoreLineBreaks");
                        f.setAccessible(true);
                        f.set(null, Boolean.TRUE);
                        return false;
                    }
                });
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void addSantuarioJSR105Provider() {
        AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                String providerName = "ApacheXMLDSig";
                Provider currentProvider = Security.getProvider(providerName);
                if (currentProvider == null) {
                    Security.addProvider((Provider)new XMLDSigRI());
                }
                return true;
            }
        });
    }
}

