/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xmlsecurity.processor;

import java.lang.reflect.Field;
import java.util.Map;
import javax.xml.crypto.XMLCryptoContext;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.component.xmlsecurity.SantuarioUtil;
import org.apache.camel.component.xmlsecurity.api.XmlSignatureConstants;
import org.apache.camel.component.xmlsecurity.processor.XmlSignatureConfiguration;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class XmlSignatureProcessor
implements Processor {
    private static final Logger LOG = LoggerFactory.getLogger(XmlSignatureProcessor.class);

    public abstract XmlSignatureConfiguration getConfiguration();

    void setUriDereferencerAndBaseUri(XMLCryptoContext context) {
        this.setUriDereferencer(context);
        this.setBaseUri(context);
    }

    private void setUriDereferencer(XMLCryptoContext context) {
        if (this.getConfiguration().getUriDereferencer() != null) {
            context.setURIDereferencer(this.getConfiguration().getUriDereferencer());
            LOG.debug("URI dereferencer set");
        }
    }

    private void setBaseUri(XMLCryptoContext context) {
        if (this.getConfiguration().getBaseUri() != null) {
            context.setBaseURI(this.getConfiguration().getBaseUri());
            LOG.debug("Base URI {} set", (Object)context.getBaseURI());
        }
    }

    protected void setCryptoContextProperties(XMLCryptoContext cryptoContext) {
        Map<String, ? extends Object> props = this.getConfiguration().getCryptoContextProperties();
        if (props == null) {
            return;
        }
        for (String prop : props.keySet()) {
            Object val = props.get(prop);
            cryptoContext.setProperty(prop, val);
            LOG.debug("Context property {} set to value {}", (Object)prop, val);
        }
    }

    protected void clearMessageHeaders(Message message) {
        if (this.getConfiguration().getClearHeaders() != null && this.getConfiguration().getClearHeaders().booleanValue()) {
            Map headers = message.getHeaders();
            for (Field f : XmlSignatureConstants.class.getFields()) {
                headers.remove(ObjectHelper.lookupConstantFieldValue(XmlSignatureConstants.class, (String)f.getName()));
            }
        }
    }

    static {
        try {
            SantuarioUtil.initializeSantuario();
            SantuarioUtil.addSantuarioJSR105Provider();
        }
        catch (Throwable t) {
            LOG.info("Cannot add the SantuarioJSR105Provider due to {0}, fall back to JRE default.", t);
        }
    }
}

