/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xmlsecurity.processor;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.xml.crypto.AlgorithmMethod;
import javax.xml.crypto.KeySelector;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLObject;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.xmlsecurity.api.XmlSignatureException;
import org.apache.camel.component.xmlsecurity.api.XmlSignatureFormatException;
import org.apache.camel.component.xmlsecurity.api.XmlSignatureHelper;
import org.apache.camel.component.xmlsecurity.api.XmlSignatureInvalidKeyException;
import org.apache.camel.component.xmlsecurity.api.XmlSignatureNoKeyException;
import org.apache.camel.component.xmlsecurity.api.XmlSignatureProperties;
import org.apache.camel.component.xmlsecurity.processor.XmlSignatureProcessor;
import org.apache.camel.component.xmlsecurity.processor.XmlSignerConfiguration;
import org.apache.camel.util.IOHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XmlSignerProcessor
extends XmlSignatureProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(XmlSignerProcessor.class);
    private static final String SHA512 = "sha512";
    private static final String SHA384 = "sha384";
    private static final String SHA256 = "sha256";
    private static final String SHA1 = "sha1";
    private static final String HTTP_WWW_W3_ORG_2001_04_XMLDSIG_MORE_SHA384 = "http://www.w3.org/2001/04/xmldsig-more#sha384";
    private final XmlSignerConfiguration config;

    public XmlSignerProcessor(XmlSignerConfiguration config) {
        this.config = config;
    }

    @Override
    public XmlSignerConfiguration getConfiguration() {
        return this.config;
    }

    public void process(Exchange exchange) throws Exception {
        try {
            LOG.debug("XML signature generation started using algorithm {} and canonicalization method {}", (Object)this.getConfiguration().getSignatureAlgorithm(), (Object)this.getConfiguration().getCanonicalizationMethod().getAlgorithm());
            Message out = exchange.getOut();
            out.copyFrom(exchange.getIn());
            Document outputDoc = this.sign(out);
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            XmlSignatureHelper.transformNonTextNodeToOutputStream(outputDoc, outStream, this.omitXmlDeclaration(out));
            byte[] data = outStream.toByteArray();
            out.setBody((Object)data);
            this.clearMessageHeaders(out);
            LOG.debug("XML signature generation finished");
        }
        catch (Exception e) {
            exchange.setOut(null);
            throw e;
        }
    }

    protected Document sign(Message out) throws Exception {
        try {
            XMLSignatureFactory fac;
            try {
                fac = XMLSignatureFactory.getInstance("DOM", "ApacheXMLDSig");
            }
            catch (NoSuchProviderException ex) {
                fac = XMLSignatureFactory.getInstance("DOM");
            }
            Node node = this.getMessageBodyNode(out);
            Node parent = this.getParentOfSignature(out, node);
            KeySelector keySelector = this.getConfiguration().getKeyAccessor().getKeySelector(out);
            if (keySelector == null) {
                throw new XmlSignatureNoKeyException("Key selector is missing for XML signature generation. Specify a key selector in the configuration.");
            }
            KeyInfo keyInfo = this.getConfiguration().getKeyAccessor().getKeyInfo(out, node, fac.getKeyInfoFactory());
            String signatureId = "_" + UUID.randomUUID().toString();
            LOG.debug("Signature Id {}", (Object)signatureId);
            XmlSignatureProperties.Input input = new InputBuilder().contentDigestAlgorithm(this.getDigestAlgorithmUri()).keyInfo(keyInfo).message(out).messageBodyNode(node).parent(parent).signatureAlgorithm(this.getConfiguration().getSignatureAlgorithm()).signatureFactory(fac).signatureId(signatureId).build();
            XmlSignatureProperties.Output properties = this.getSignatureProperties(input);
            List<? extends XMLObject> objects = this.getObjects(input, properties);
            List<? extends Reference> refs = this.getReferences(input, properties, this.getKeyInfoId(keyInfo));
            SignedInfo si = this.createSignedInfo(fac, refs);
            if (parent == null) {
                parent = XmlSignatureHelper.newDocumentBuilder(Boolean.TRUE).newDocument();
            }
            DOMSignContext dsc = this.createAndConfigureSignContext(parent, keySelector);
            XMLSignature signature = fac.newXMLSignature(si, keyInfo, objects, signatureId, null);
            signature.sign(dsc);
            return XmlSignatureHelper.getDocument(parent);
        }
        catch (XMLSignatureException se) {
            if (se.getCause() instanceof InvalidKeyException) {
                throw new XmlSignatureInvalidKeyException(se.getMessage(), se);
            }
            throw new XmlSignatureException(se);
        }
        catch (GeneralSecurityException e) {
            throw new XmlSignatureException(e);
        }
    }

    protected XmlSignatureProperties.Output getSignatureProperties(XmlSignatureProperties.Input input) throws Exception {
        XmlSignatureProperties propGetter = this.getConfiguration().getProperties();
        XmlSignatureProperties.Output propsOutput = null;
        if (propGetter != null) {
            propsOutput = propGetter.get(input);
        }
        return propsOutput;
    }

    private DOMSignContext createAndConfigureSignContext(Node parent, KeySelector keySelector) {
        DOMSignContext dsc = new DOMSignContext(keySelector, parent);
        if (this.getConfiguration().getPrefixForXmlSignatureNamespace() != null && !this.getConfiguration().getPrefixForXmlSignatureNamespace().isEmpty()) {
            dsc.putNamespacePrefix("http://www.w3.org/2000/09/xmldsig#", this.getConfiguration().getPrefixForXmlSignatureNamespace());
        }
        this.setCryptoContextProperties(dsc);
        this.setUriDereferencerAndBaseUri(dsc);
        return dsc;
    }

    protected Boolean omitXmlDeclaration(Message message) {
        Boolean omitXmlDeclaration = (Boolean)message.getHeader("CamelXmlSignatureOmitXmlDeclaration", Boolean.class);
        if (omitXmlDeclaration == null) {
            omitXmlDeclaration = this.getConfiguration().getOmitXmlDeclaration();
        }
        if (omitXmlDeclaration == null) {
            omitXmlDeclaration = Boolean.FALSE;
        }
        LOG.debug("Omit XML declaration: {}", (Object)omitXmlDeclaration);
        return omitXmlDeclaration;
    }

    protected SignedInfo createSignedInfo(XMLSignatureFactory fac, List<? extends Reference> refs) throws Exception {
        return fac.newSignedInfo(fac.newCanonicalizationMethod(this.getConfiguration().getCanonicalizationMethod().getAlgorithm(), (C14NMethodParameterSpec)this.getConfiguration().getCanonicalizationMethod().getParameterSpec()), this.getSignatureMethod(this.getConfiguration().getSignatureAlgorithm(), fac), refs);
    }

    private SignatureMethod getSignatureMethod(String signatureAlgorithm, XMLSignatureFactory fac) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        return fac.newSignatureMethod(signatureAlgorithm, null);
    }

    protected Node getMessageBodyNode(Message message) throws Exception {
        Node node;
        InputStream is = (InputStream)message.getMandatoryBody(InputStream.class);
        Boolean isPlainText = this.isPlainText(message);
        if (isPlainText != null && isPlainText.booleanValue()) {
            node = this.getTextNode(message, is);
        } else {
            Document doc = this.parseInput(is, this.getConfiguration().getDisallowDoctypeDecl());
            node = doc.getDocumentElement();
            LOG.debug("Root element of document to be signed: {}", (Object)node);
        }
        return node;
    }

    protected Boolean isPlainText(Message message) {
        Boolean isPlainText = (Boolean)message.getHeader("CamelXmlSignatureMessageIsPlainText", Boolean.class);
        if (isPlainText == null) {
            isPlainText = this.getConfiguration().getPlainText();
        }
        LOG.debug("Is plain text: {}", (Object)isPlainText);
        return isPlainText;
    }

    protected Element getParentOfSignature(Message inMessage, Node messageBodyNode) throws Exception {
        if (this.getConfiguration().getParentLocalName() == null) {
            return null;
        }
        if (messageBodyNode.getParentNode() == null || messageBodyNode.getParentNode().getNodeType() != 9) {
            throw new XmlSignatureFormatException("Incomming message has wrong format: It is not an XML document. Cannot create an enveloped XML signature.");
        }
        Document doc = (Document)messageBodyNode.getParentNode();
        NodeList parents = doc.getElementsByTagNameNS(this.getConfiguration().getParentNamespace(), this.getConfiguration().getParentLocalName());
        if (parents == null || parents.getLength() == 0) {
            throw new XmlSignatureFormatException(String.format("Incoming message has wrong format: The parent element with the local name %s and the namespace %s was not found in the message to build an enveloped XML signature.", this.getConfiguration().getParentLocalName(), this.getConfiguration().getParentNamespace()));
        }
        return (Element)parents.item(0);
    }

    protected List<? extends Reference> getReferences(XmlSignatureProperties.Input input, XmlSignatureProperties.Output properties, String keyInfoId) throws Exception {
        Reference ref = this.createReference(input.getSignatureFactory(), this.getContentReferenceUri(input.getMessage()), this.getContentReferenceType(input.getMessage()));
        Reference keyInfoRef = this.createKeyInfoReference(input.getSignatureFactory(), keyInfoId, input.getContentDigestAlgorithm());
        int propsRefsSize = properties == null || properties.getReferences() == null || properties.getReferences().isEmpty() ? 0 : properties.getReferences().size();
        int size = keyInfoRef == null ? propsRefsSize + 1 : propsRefsSize + 2;
        ArrayList<? extends Reference> referenceList = new ArrayList<Reference>(size);
        referenceList.add(ref);
        if (keyInfoRef != null) {
            referenceList.add(keyInfoRef);
        }
        if (properties != null && properties.getReferences() != null && !properties.getReferences().isEmpty()) {
            referenceList.addAll(properties.getReferences());
        }
        return referenceList;
    }

    protected List<? extends XMLObject> getObjects(XmlSignatureProperties.Input input, XmlSignatureProperties.Output properties) throws Exception {
        if (this.isEnveloped()) {
            if (properties == null || properties.getObjects() == null) {
                return Collections.emptyList();
            }
            return properties.getObjects();
        }
        String objectId = this.getConfiguration().getContentObjectId();
        LOG.debug("Object Content Id {}", (Object)objectId);
        XMLObject obj = this.createXMLObject(input.getSignatureFactory(), input.getMessageBodyNode(), objectId);
        if (properties == null || properties.getObjects() == null || properties.getObjects().isEmpty()) {
            return Collections.singletonList(obj);
        }
        ArrayList<? extends XMLObject> result = new ArrayList<XMLObject>(properties.getObjects().size() + 1);
        result.add(obj);
        result.addAll(properties.getObjects());
        return result;
    }

    private Node getTextNode(Message inMessage, InputStream is) throws IOException, ParserConfigurationException, XmlSignatureException {
        LOG.debug("Message body to be signed is plain text");
        String encoding = this.getMessageEncoding(inMessage);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        IOHelper.copyAndCloseInput((InputStream)is, (OutputStream)bos);
        try {
            String text = new String(bos.toByteArray(), encoding);
            return XmlSignatureHelper.newDocumentBuilder(true).newDocument().createTextNode(text);
        }
        catch (UnsupportedEncodingException e) {
            throw new XmlSignatureException(String.format("The message encoding %s is not supported.", encoding), e);
        }
    }

    protected String getMessageEncoding(Message inMessage) {
        String encoding = (String)inMessage.getHeader("CamelXmlSignaturePlainTextEncoding", String.class);
        if (encoding == null) {
            encoding = this.getConfiguration().getPlainTextEncoding();
        }
        LOG.debug("Messge encoding: {}", (Object)encoding);
        return encoding;
    }

    protected Document parseInput(InputStream is, Boolean disallowDoctypeDecl) throws XmlSignatureFormatException, ParserConfigurationException, IOException {
        try {
            Document document = XmlSignatureHelper.newDocumentBuilder(disallowDoctypeDecl).parse(is);
            return document;
        }
        catch (SAXException e) {
            throw new XmlSignatureFormatException("XML signature generation not possible. Sent message is not an XML document. Check the sent message.", e);
        }
        finally {
            IOHelper.close((Closeable)is, (String)"input stream");
        }
    }

    protected Reference createReference(XMLSignatureFactory fac, String uri, String type) throws InvalidAlgorithmParameterException, XmlSignatureException {
        try {
            List<Transform> transforms = this.getTransforms(fac);
            Reference ref = fac.newReference(uri, fac.newDigestMethod(this.getDigestAlgorithmUri(), null), transforms, type, null);
            return ref;
        }
        catch (NoSuchAlgorithmException e) {
            throw new XmlSignatureException("Wrong algorithm specified in the configuration.", e);
        }
    }

    protected String getContentReferenceType(Message message) {
        String type = (String)message.getHeader("CamelXmlSignatureContentReferenceType", String.class);
        if (type == null) {
            type = this.getConfiguration().getContentReferenceType();
        }
        LOG.debug("Content reference type: {}", (Object)type);
        return type;
    }

    protected String getContentReferenceUri(Message message) {
        String uri = (String)message.getHeader("CamelXmlSignatureContentReferenceUri", String.class);
        if (uri == null) {
            uri = this.getConfiguration().getContentReferenceUri();
        }
        if (uri == null) {
            uri = this.isEnveloped() ? "" : "#" + this.getConfiguration().getContentObjectId();
        }
        LOG.debug("Content reference uri: {}", (Object)uri);
        return uri;
    }

    protected XMLObject createXMLObject(XMLSignatureFactory fac, Node node, String id) {
        return fac.newXMLObject(Collections.singletonList(new DOMStructure(node)), id, null, null);
    }

    private List<Transform> getTransforms(XMLSignatureFactory fac) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        boolean isEnveloped = this.isEnveloped();
        List<AlgorithmMethod> configuredTrafos = this.getConfiguration().getTransformMethods();
        if (isEnveloped) {
            if (configuredTrafos.size() > 0) {
                if (!this.containsEnvelopedTransform(configuredTrafos)) {
                    configuredTrafos = new ArrayList<AlgorithmMethod>(configuredTrafos.size() + 1);
                    configuredTrafos.add(XmlSignatureHelper.getEnvelopedTransform());
                    configuredTrafos.addAll(this.getConfiguration().getTransformMethods());
                }
            } else {
                configuredTrafos = new ArrayList<AlgorithmMethod>(2);
                configuredTrafos.add(XmlSignatureHelper.getEnvelopedTransform());
                configuredTrafos.add(XmlSignatureHelper.getCanonicalizationMethod("http://www.w3.org/TR/2001/REC-xml-c14n-20010315"));
            }
        }
        ArrayList<Transform> transforms = new ArrayList<Transform>(configuredTrafos.size());
        for (AlgorithmMethod trafo : configuredTrafos) {
            Transform transform = fac.newTransform(trafo.getAlgorithm(), (TransformParameterSpec)trafo.getParameterSpec());
            transforms.add(transform);
            LOG.debug("Transform method: {}", (Object)trafo.getAlgorithm());
        }
        return transforms;
    }

    protected boolean isEnveloped() {
        return this.getConfiguration().getParentLocalName() != null;
    }

    private boolean containsEnvelopedTransform(List<AlgorithmMethod> configuredTrafos) {
        for (AlgorithmMethod m : configuredTrafos) {
            if (!"http://www.w3.org/2000/09/xmldsig#enveloped-signature".equals(m.getAlgorithm())) continue;
            return true;
        }
        return false;
    }

    protected String getDigestAlgorithmUri() throws XmlSignatureException {
        String signatureAlgorithm;
        String result = this.getConfiguration().getDigestAlgorithm();
        if (result == null && (signatureAlgorithm = this.getConfiguration().getSignatureAlgorithm()) != null) {
            if (signatureAlgorithm.contains(SHA1)) {
                result = "http://www.w3.org/2000/09/xmldsig#sha1";
            } else if (signatureAlgorithm.contains(SHA256)) {
                result = "http://www.w3.org/2001/04/xmlenc#sha256";
            } else if (signatureAlgorithm.contains(SHA384)) {
                result = HTTP_WWW_W3_ORG_2001_04_XMLDSIG_MORE_SHA384;
            } else if (signatureAlgorithm.contains(SHA512)) {
                result = "http://www.w3.org/2001/04/xmlenc#sha512";
            }
        }
        if (result != null) {
            LOG.debug("Digest algorithm: {}", (Object)result);
            return result;
        }
        throw new XmlSignatureException("Digest algorithm missing for XML signature generation. Specify the digest algorithm in the configuration.");
    }

    protected Reference createKeyInfoReference(XMLSignatureFactory fac, String keyInfoId, String digestAlgorithm) throws Exception {
        if (keyInfoId == null) {
            return null;
        }
        if (this.getConfiguration().getAddKeyInfoReference() == null) {
            return null;
        }
        if (!this.getConfiguration().getAddKeyInfoReference().booleanValue()) {
            return null;
        }
        LOG.debug("Creating reference to key info element with Id: {}", (Object)keyInfoId);
        ArrayList<Transform> transforms = new ArrayList<Transform>(1);
        Transform transform = fac.newTransform("http://www.w3.org/TR/2001/REC-xml-c14n-20010315", (TransformParameterSpec)null);
        transforms.add(transform);
        return fac.newReference("#" + keyInfoId, fac.newDigestMethod(digestAlgorithm, null), transforms, null, null);
    }

    private String getKeyInfoId(KeyInfo keyInfo) throws Exception {
        if (keyInfo == null) {
            return null;
        }
        return keyInfo.getId();
    }

    private static class InputBuilder {
        private XMLSignatureFactory signatureFactory;
        private String signatureAlgorithm;
        private Node parent;
        private Node messageBodyNode;
        private Message message;
        private KeyInfo keyInfo;
        private String contentDigestAlgorithm;
        private String signatureId;

        private InputBuilder() {
        }

        public InputBuilder signatureFactory(XMLSignatureFactory signatureFactory) {
            this.signatureFactory = signatureFactory;
            return this;
        }

        public InputBuilder signatureAlgorithm(String signatureAlgorithm) {
            this.signatureAlgorithm = signatureAlgorithm;
            return this;
        }

        public InputBuilder parent(Node parent) {
            this.parent = parent;
            return this;
        }

        public InputBuilder messageBodyNode(Node messageBodyNode) {
            this.messageBodyNode = messageBodyNode;
            return this;
        }

        public InputBuilder message(Message message) {
            this.message = message;
            return this;
        }

        public InputBuilder keyInfo(KeyInfo keyInfo) {
            this.keyInfo = keyInfo;
            return this;
        }

        public InputBuilder contentDigestAlgorithm(String contentDigestAlgorithm) {
            this.contentDigestAlgorithm = contentDigestAlgorithm;
            return this;
        }

        public InputBuilder signatureId(String signatureId) {
            this.signatureId = signatureId;
            return this;
        }

        public XmlSignatureProperties.Input build() {
            return new XmlSignatureProperties.Input(){

                @Override
                public XMLSignatureFactory getSignatureFactory() {
                    return InputBuilder.this.signatureFactory;
                }

                @Override
                public String getSignatureAlgorithm() {
                    return InputBuilder.this.signatureAlgorithm;
                }

                @Override
                public Node getParent() {
                    return InputBuilder.this.parent;
                }

                @Override
                public Node getMessageBodyNode() {
                    return InputBuilder.this.messageBodyNode;
                }

                @Override
                public Message getMessage() {
                    return InputBuilder.this.message;
                }

                @Override
                public KeyInfo getKeyInfo() {
                    return InputBuilder.this.keyInfo;
                }

                @Override
                public String getContentDigestAlgorithm() {
                    return InputBuilder.this.contentDigestAlgorithm;
                }

                @Override
                public String getSignatureId() {
                    return InputBuilder.this.signatureId;
                }
            };
        }
    }
}

