/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.shiro.security;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import org.apache.camel.component.shiro.security.ShiroSecurityToken;
import org.apache.camel.util.IOHelper;
import org.apache.shiro.crypto.CipherService;
import org.apache.shiro.util.ByteSource;

public final class ShiroSecurityHelper {
    private ShiroSecurityHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteSource encrypt(ShiroSecurityToken securityToken, byte[] passPhrase, CipherService cipherService) throws Exception {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        ObjectOutputStream serialStream = new ObjectOutputStream(stream);
        try {
            serialStream.writeObject(securityToken);
            ByteSource byteSource = cipherService.encrypt(stream.toByteArray(), passPhrase);
            return byteSource;
        }
        finally {
            ShiroSecurityHelper.close(serialStream);
            IOHelper.close((Closeable)stream);
        }
    }

    private static void close(ObjectOutput output) {
        try {
            output.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

