/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty.ssl;

import java.io.Closeable;
import java.io.InputStream;
import java.security.KeyStore;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManagerFactory;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ResourceHelper;

public final class SSLEngineFactory {
    private static final String SSL_PROTOCOL = "TLS";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SSLContext createSSLContext(ClassResolver classResolver, String keyStoreFormat, String securityProvider, String keyStoreResource, String trustStoreResource, char[] passphrase) throws Exception {
        KeyStore ks = KeyStore.getInstance(keyStoreFormat);
        InputStream is = ResourceHelper.resolveMandatoryResourceAsInputStream((ClassResolver)classResolver, (String)keyStoreResource);
        try {
            ks.load(is, passphrase);
        }
        finally {
            IOHelper.close((Closeable)is);
        }
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(securityProvider);
        kmf.init(ks, passphrase);
        SSLContext answer = SSLContext.getInstance(SSL_PROTOCOL);
        if (trustStoreResource != null) {
            KeyStore ts = KeyStore.getInstance(keyStoreFormat);
            is = ResourceHelper.resolveMandatoryResourceAsInputStream((ClassResolver)classResolver, (String)trustStoreResource);
            try {
                ts.load(is, passphrase);
            }
            finally {
                IOHelper.close((Closeable)is);
            }
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(securityProvider);
            tmf.init(ts);
            answer.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
        } else {
            answer.init(kmf.getKeyManagers(), null, null);
        }
        return answer;
    }

    public SSLEngine createServerSSLEngine(SSLContext sslContext) {
        SSLEngine serverEngine = sslContext.createSSLEngine();
        serverEngine.setUseClientMode(false);
        serverEngine.setNeedClientAuth(true);
        return serverEngine;
    }

    public SSLEngine createClientSSLEngine(SSLContext sslContext) {
        SSLEngine clientEngine = sslContext.createSSLEngine();
        clientEngine.setUseClientMode(true);
        return clientEngine;
    }
}

