/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.karaf.commands;

import org.apache.camel.CamelContext;
import org.apache.camel.karaf.commands.CamelController;
import org.apache.camel.processor.interceptor.BacklogTracer;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.shell.console.OsgiCommandSupport;

@Command(scope="camel", name="backlog-tracer-info", description="Displays the current status of the Backlog tracer")
public class BacklogTracerInfo
extends OsgiCommandSupport {
    @Argument(index=0, name="context", description="The name of the Camel context.", required=true, multiValued=false)
    String context;
    private CamelController camelController;

    public void setCamelController(CamelController camelController) {
        this.camelController = camelController;
    }

    protected Object doExecute() throws Exception {
        CamelContext camel = this.camelController.getCamelContext(this.context);
        if (camel == null) {
            System.err.println("CamelContext " + this.context + " not found.");
            return null;
        }
        BacklogTracer backlogTracer = BacklogTracer.getBacklogTracer((CamelContext)camel);
        if (backlogTracer == null) {
            backlogTracer = (BacklogTracer)camel.getDefaultBacklogTracer();
        }
        System.out.println("BacklogTracer context:\t\t" + camel.getName());
        System.out.println("BacklogTracer enabled:\t\t" + backlogTracer.isEnabled());
        System.out.println("BacklogTracer pattern:\t\t" + (backlogTracer.getTracePattern() != null ? backlogTracer.getTracePattern() : ""));
        System.out.println("BacklogTracer filter:\t\t" + (backlogTracer.getTraceFilter() != null ? backlogTracer.getTraceFilter() : ""));
        System.out.println("BacklogTracer removeOnDump:\t" + backlogTracer.isRemoveOnDump());
        System.out.println("BacklogTracer backlogSize:\t" + backlogTracer.getBacklogSize());
        System.out.println("BacklogTracer tracerCount:\t" + backlogTracer.getTraceCounter());
        System.out.println("BacklogTracer body...");
        System.out.println("\tmaxChars:\t\t" + backlogTracer.getBodyMaxChars());
        System.out.println("\tincludeFiles:\t\t" + backlogTracer.isBodyIncludeFiles());
        System.out.println("\tincludeStreams:\t\t" + backlogTracer.isBodyIncludeStreams());
        return null;
    }
}

