/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.elasticsearch;

import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExpectedBodyTypeException;
import org.apache.camel.Message;
import org.apache.camel.component.elasticsearch.ElasticsearchEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.elasticsearch.action.ListenableActionFuture;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class ElasticsearchProducer
extends DefaultProducer {
    public ElasticsearchProducer(ElasticsearchEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    public ElasticsearchEndpoint getEndpoint() {
        return (ElasticsearchEndpoint)super.getEndpoint();
    }

    public void process(Exchange exchange) throws Exception {
        String operation = (String)exchange.getIn().getHeader("operation", String.class);
        if (operation == null) {
            operation = this.getEndpoint().getConfig().getOperation();
        }
        if (operation == null) {
            throw new IllegalArgumentException("operation is missing");
        }
        Client client = this.getEndpoint().getClient();
        if (operation.equalsIgnoreCase("INDEX")) {
            this.addToIndex(client, exchange);
        } else if (operation.equalsIgnoreCase("GET_BY_ID")) {
            this.getById(client, exchange);
        } else if (operation.equalsIgnoreCase("DELETE")) {
            this.deleteById(client, exchange);
        } else {
            throw new IllegalArgumentException("operation value '" + operation + "' is not supported");
        }
    }

    public void getById(Client client, Exchange exchange) {
        String indexType;
        String indexName = (String)exchange.getIn().getHeader("indexName", String.class);
        if (indexName == null) {
            indexName = this.getEndpoint().getConfig().getIndexName();
        }
        if ((indexType = (String)exchange.getIn().getHeader("indexType", String.class)) == null) {
            indexType = this.getEndpoint().getConfig().getIndexType();
        }
        String indexId = (String)exchange.getIn().getBody(String.class);
        GetResponse response = (GetResponse)client.prepareGet(indexName, indexType, indexId).execute().actionGet();
        exchange.getIn().setBody((Object)response);
    }

    public void deleteById(Client client, Exchange exchange) {
        String indexType;
        String indexName = (String)exchange.getIn().getHeader("indexName", String.class);
        if (indexName == null) {
            indexName = this.getEndpoint().getConfig().getIndexName();
        }
        if ((indexType = (String)exchange.getIn().getHeader("indexType", String.class)) == null) {
            indexType = this.getEndpoint().getConfig().getIndexType();
        }
        String indexId = (String)exchange.getIn().getBody(String.class);
        DeleteResponse response = (DeleteResponse)client.prepareDelete(indexName, indexType, indexId).execute().actionGet();
        exchange.getIn().setBody((Object)response);
    }

    public void addToIndex(Client client, Exchange exchange) {
        String indexType;
        String indexName = (String)exchange.getIn().getHeader("indexName", String.class);
        if (indexName == null) {
            indexName = this.getEndpoint().getConfig().getIndexName();
        }
        if ((indexType = (String)exchange.getIn().getHeader("indexType", String.class)) == null) {
            indexType = this.getEndpoint().getConfig().getIndexType();
        }
        IndexRequestBuilder prepareIndex = client.prepareIndex(indexName, indexType);
        if (!this.setIndexRequestSource(exchange.getIn(), prepareIndex)) {
            throw new ExpectedBodyTypeException(exchange, XContentBuilder.class);
        }
        ListenableActionFuture future = prepareIndex.execute();
        IndexResponse response = (IndexResponse)future.actionGet();
        exchange.getIn().setBody((Object)response.getId());
    }

    private boolean setIndexRequestSource(Message msg, IndexRequestBuilder builder) {
        Object body = null;
        boolean converted = false;
        Class[] types = new Class[]{XContentBuilder.class, Map.class, byte[].class, String.class};
        for (int i = 0; i < types.length && body == null; ++i) {
            Class type = types[i];
            body = msg.getBody(type);
        }
        if (body != null) {
            converted = true;
            if (body instanceof byte[]) {
                builder.setSource((byte[])body);
            } else if (body instanceof Map) {
                builder.setSource((Map)body);
            } else if (body instanceof String) {
                builder.setSource((String)body);
            } else if (body instanceof XContentBuilder) {
                builder.setSource((XContentBuilder)body);
            } else {
                converted = false;
            }
        }
        return converted;
    }
}

