/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.javaspace;

import java.io.IOException;
import java.rmi.RMISecurityManager;
import net.jini.core.discovery.LookupLocator;
import net.jini.core.entry.Entry;
import net.jini.core.lookup.ServiceRegistrar;
import net.jini.core.lookup.ServiceTemplate;
import net.jini.core.transaction.Transaction;
import net.jini.core.transaction.TransactionFactory;
import net.jini.core.transaction.server.TransactionManager;

public class TransactionHelper {
    private static TransactionHelper me;
    private String uri;
    private TransactionManager trManager;

    public TransactionHelper(String uri) {
        this.uri = uri;
    }

    public static TransactionHelper getInstance(String uri) {
        if (me == null) {
            me = new TransactionHelper(uri);
        }
        return me;
    }

    public Transaction.Created getJiniTransaction(long timeout) throws Exception {
        if (null == this.trManager) {
            this.trManager = this.findTransactionManager(this.uri);
        }
        Transaction.Created tCreated = TransactionFactory.create((TransactionManager)this.trManager, (long)timeout);
        return tCreated;
    }

    private TransactionManager findTransactionManager(String uri) throws IOException, ClassNotFoundException {
        if (System.getSecurityManager() == null) {
            System.setSecurityManager(new RMISecurityManager());
        }
        Class[] classes = new Class[]{TransactionManager.class};
        ServiceTemplate tmpl = new ServiceTemplate(null, classes, new Entry[0]);
        LookupLocator locator = new LookupLocator(uri);
        ServiceRegistrar sr = locator.getRegistrar();
        TransactionManager tm = (TransactionManager)sr.lookup(tmpl);
        return tm;
    }
}

