/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.http4;

import org.apache.camel.component.http4.HttpClientConfigurer;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.DefaultHttpClient;

public class BasicAuthenticationHttpClientConfigurer
implements HttpClientConfigurer {
    private final String username;
    private final String password;
    private final String domain;
    private final String host;

    public BasicAuthenticationHttpClientConfigurer(String user, String pwd, String domain, String host) {
        this.username = user;
        this.password = pwd;
        this.domain = domain;
        this.host = host;
    }

    @Override
    public void configureHttpClient(HttpClient client) {
        Object defaultcreds = this.domain != null ? new NTCredentials(this.username, this.password, this.host, this.domain) : new UsernamePasswordCredentials(this.username, this.password);
        ((DefaultHttpClient)client).getCredentialsProvider().setCredentials(AuthScope.ANY, (Credentials)defaultcreds);
    }
}

