/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hbase;

public enum HbaseAttribute {
    HBASE_ROW_ID("CamelHBaseRowId"),
    HBASE_ROW_TYPE("CamelHBaseRowType"),
    HBASE_MARKED_ROW_ID("CamelHBaseMarkedRowId"),
    HBASE_FAMILY("CamelHBaseFamily"),
    HBASE_QUALIFIER("CamelHBaseQualifier"),
    HBASE_VALUE("CamelHBaseValue"),
    HBASE_VALUE_TYPE("CamelHBaseValueType");

    private final String value;

    private HbaseAttribute(String value) {
        this.value = value;
    }

    public String asHeader(int i) {
        if (i > 1) {
            return this.value + i;
        }
        return this.value;
    }

    public String asHeader() {
        return this.value;
    }

    public String asOption() {
        String normalizedValue = this.value.replaceAll("CamelHBase", "");
        return normalizedValue.substring(0, 1).toLowerCase() + normalizedValue.substring(1);
    }

    public String asOption(int i) {
        String option = this.asOption();
        if (i > 1) {
            return option + i;
        }
        return option;
    }

    public String toString() {
        return this.value;
    }
}

