/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import org.apache.camel.CamelContext;
import org.apache.camel.NoSuchBeanException;
import org.apache.camel.Processor;
import org.apache.camel.component.bean.BeanHolder;
import org.apache.camel.component.bean.BeanInfo;
import org.apache.camel.component.bean.ConstantBeanHolder;
import org.apache.camel.component.bean.ParameterMappingStrategy;
import org.apache.camel.spi.Registry;
import org.apache.camel.util.CamelContextHelper;

public class RegistryBean
implements BeanHolder {
    private final Object lock = new Object();
    private final CamelContext context;
    private final String name;
    private final Registry registry;
    private volatile Processor processor;
    private volatile BeanInfo beanInfo;
    private volatile Object bean;
    private ParameterMappingStrategy parameterMappingStrategy;

    public RegistryBean(CamelContext context, String name) {
        this.context = context;
        this.name = name;
        this.registry = context.getRegistry();
    }

    public RegistryBean(Registry registry, CamelContext context, String name) {
        this.registry = registry;
        this.context = context;
        this.name = name;
    }

    public String toString() {
        return "bean: " + this.name;
    }

    public ConstantBeanHolder createCacheHolder() throws Exception {
        Object bean = this.getBean();
        BeanInfo info = this.createBeanInfo(bean);
        return new ConstantBeanHolder(bean, info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getBean() throws NoSuchBeanException {
        Object value = this.lookupBean();
        if (value != null) {
            if (value instanceof Class) {
                value = this.context.getInjector().newInstance((Class)value);
            }
            this.bean = value;
            return value;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.bean != null) {
                return this.bean;
            }
            this.bean = this.context.getClassResolver().resolveClass(this.name);
            if (this.bean == null) {
                throw new NoSuchBeanException(this.name);
            }
            if (this.bean instanceof Class) {
                this.bean = this.context.getInjector().newInstance((Class)this.bean);
            }
        }
        return this.bean;
    }

    @Override
    public Processor getProcessor() {
        if (this.processor == null && this.bean != null) {
            this.processor = CamelContextHelper.convertTo(this.context, Processor.class, this.bean);
        }
        return this.processor;
    }

    @Override
    public BeanInfo getBeanInfo() {
        if (this.beanInfo == null && this.bean != null) {
            this.beanInfo = this.createBeanInfo(this.bean);
        }
        return this.beanInfo;
    }

    @Override
    public BeanInfo getBeanInfo(Object bean) {
        if (this.bean == bean) {
            return this.getBeanInfo();
        }
        return this.createBeanInfo(bean);
    }

    public String getName() {
        return this.name;
    }

    public Registry getRegistry() {
        return this.registry;
    }

    public CamelContext getContext() {
        return this.context;
    }

    public ParameterMappingStrategy getParameterMappingStrategy() {
        if (this.parameterMappingStrategy == null) {
            this.parameterMappingStrategy = this.createParameterMappingStrategy();
        }
        return this.parameterMappingStrategy;
    }

    public void setParameterMappingStrategy(ParameterMappingStrategy parameterMappingStrategy) {
        this.parameterMappingStrategy = parameterMappingStrategy;
    }

    protected BeanInfo createBeanInfo(Object bean) {
        return new BeanInfo(this.context, bean.getClass(), this.getParameterMappingStrategy());
    }

    protected ParameterMappingStrategy createParameterMappingStrategy() {
        return BeanInfo.createParameterMappingStrategy(this.context);
    }

    protected Object lookupBean() {
        return this.registry.lookupByName(this.name);
    }
}

