/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.impl.DefaultUnitOfWork;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.spi.UnitOfWork;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class MDCUnitOfWork
extends DefaultUnitOfWork {
    public static final String MDC_BREADCRUMB_ID = "camel.breadcrumbId";
    public static final String MDC_EXCHANGE_ID = "camel.exchangeId";
    public static final String MDC_MESSAGE_ID = "camel.messageId";
    public static final String MDC_CORRELATION_ID = "camel.correlationId";
    public static final String MDC_ROUTE_ID = "camel.routeId";
    public static final String MDC_CAMEL_CONTEXT_ID = "camel.contextId";
    public static final String MDC_TRANSACTION_KEY = "camel.transactionKey";
    private static final Logger LOG = LoggerFactory.getLogger(MDCUnitOfWork.class);
    private final String originalBreadcrumbId;
    private final String originalExchangeId = MDC.get((String)"camel.exchangeId");
    private final String originalMessageId = MDC.get((String)"camel.messageId");
    private final String originalCorrelationId;
    private final String originalRouteId;
    private final String originalCamelContextId;
    private final String originalTransactionKey;

    public MDCUnitOfWork(Exchange exchange) {
        super(exchange, LOG);
        String breadcrumbId;
        this.originalBreadcrumbId = MDC.get((String)MDC_BREADCRUMB_ID);
        this.originalCorrelationId = MDC.get((String)MDC_CORRELATION_ID);
        this.originalRouteId = MDC.get((String)MDC_ROUTE_ID);
        this.originalCamelContextId = MDC.get((String)MDC_CAMEL_CONTEXT_ID);
        this.originalTransactionKey = MDC.get((String)MDC_TRANSACTION_KEY);
        MDC.put((String)MDC_EXCHANGE_ID, (String)exchange.getExchangeId());
        String msgId = exchange.hasOut() ? exchange.getOut().getMessageId() : exchange.getIn().getMessageId();
        MDC.put((String)MDC_MESSAGE_ID, (String)msgId);
        MDC.put((String)MDC_CAMEL_CONTEXT_ID, (String)exchange.getContext().getName());
        String corrId = exchange.getProperty("CamelCorrelationId", String.class);
        if (corrId != null) {
            MDC.put((String)MDC_CORRELATION_ID, (String)corrId);
        }
        if ((breadcrumbId = exchange.getIn().getHeader("breadcrumbId", String.class)) != null) {
            MDC.put((String)MDC_BREADCRUMB_ID, (String)breadcrumbId);
        }
    }

    @Override
    public UnitOfWork newInstance(Exchange exchange) {
        return new MDCUnitOfWork(exchange);
    }

    @Override
    public void stop() throws Exception {
        super.stop();
        this.clear();
    }

    @Override
    public void pushRouteContext(RouteContext routeContext) {
        MDC.put((String)MDC_ROUTE_ID, (String)routeContext.getRoute().getId());
        super.pushRouteContext(routeContext);
    }

    @Override
    public RouteContext popRouteContext() {
        MDC.remove((String)MDC_ROUTE_ID);
        return super.popRouteContext();
    }

    @Override
    public void beginTransactedBy(Object key) {
        MDC.put((String)MDC_TRANSACTION_KEY, (String)key.toString());
        super.beginTransactedBy(key);
    }

    @Override
    public void endTransactedBy(Object key) {
        MDC.remove((String)MDC_TRANSACTION_KEY);
        super.endTransactedBy(key);
    }

    @Override
    public AsyncCallback beforeProcess(Processor processor, Exchange exchange, AsyncCallback callback) {
        return new MDCCallback(callback);
    }

    @Override
    public void afterProcess(Processor processor, Exchange exchange, AsyncCallback callback, boolean doneSync) {
        if (!doneSync) {
            this.clear();
        }
        super.afterProcess(processor, exchange, callback, doneSync);
    }

    public void clear() {
        if (this.originalBreadcrumbId != null) {
            MDC.put((String)MDC_BREADCRUMB_ID, (String)this.originalBreadcrumbId);
        } else {
            MDC.remove((String)MDC_BREADCRUMB_ID);
        }
        if (this.originalExchangeId != null) {
            MDC.put((String)MDC_EXCHANGE_ID, (String)this.originalExchangeId);
        } else {
            MDC.remove((String)MDC_EXCHANGE_ID);
        }
        if (this.originalMessageId != null) {
            MDC.put((String)MDC_MESSAGE_ID, (String)this.originalMessageId);
        } else {
            MDC.remove((String)MDC_MESSAGE_ID);
        }
        if (this.originalCorrelationId != null) {
            MDC.put((String)MDC_CORRELATION_ID, (String)this.originalCorrelationId);
        } else {
            MDC.remove((String)MDC_CORRELATION_ID);
        }
        if (this.originalRouteId != null) {
            MDC.put((String)MDC_ROUTE_ID, (String)this.originalRouteId);
        } else {
            MDC.remove((String)MDC_ROUTE_ID);
        }
        if (this.originalCamelContextId != null) {
            MDC.put((String)MDC_CAMEL_CONTEXT_ID, (String)this.originalCamelContextId);
        } else {
            MDC.remove((String)MDC_CAMEL_CONTEXT_ID);
        }
        if (this.originalTransactionKey != null) {
            MDC.put((String)MDC_TRANSACTION_KEY, (String)this.originalTransactionKey);
        } else {
            MDC.remove((String)MDC_TRANSACTION_KEY);
        }
    }

    @Override
    public String toString() {
        return "MDCUnitOfWork";
    }

    private static final class MDCCallback
    implements AsyncCallback {
        private final AsyncCallback delegate;
        private final String breadcrumbId;
        private final String exchangeId;
        private final String messageId;
        private final String correlationId;
        private final String routeId;
        private final String camelContextId;

        private MDCCallback(AsyncCallback delegate) {
            this.delegate = delegate;
            this.exchangeId = MDC.get((String)MDCUnitOfWork.MDC_EXCHANGE_ID);
            this.messageId = MDC.get((String)MDCUnitOfWork.MDC_MESSAGE_ID);
            this.breadcrumbId = MDC.get((String)MDCUnitOfWork.MDC_BREADCRUMB_ID);
            this.correlationId = MDC.get((String)MDCUnitOfWork.MDC_CORRELATION_ID);
            this.camelContextId = MDC.get((String)MDCUnitOfWork.MDC_CAMEL_CONTEXT_ID);
            this.routeId = MDC.get((String)MDCUnitOfWork.MDC_ROUTE_ID);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void done(boolean doneSync) {
            try {
                if (!doneSync) {
                    if (this.breadcrumbId != null) {
                        MDC.put((String)MDCUnitOfWork.MDC_BREADCRUMB_ID, (String)this.breadcrumbId);
                    }
                    if (this.exchangeId != null) {
                        MDC.put((String)MDCUnitOfWork.MDC_EXCHANGE_ID, (String)this.exchangeId);
                    }
                    if (this.messageId != null) {
                        MDC.put((String)MDCUnitOfWork.MDC_MESSAGE_ID, (String)this.messageId);
                    }
                    if (this.correlationId != null) {
                        MDC.put((String)MDCUnitOfWork.MDC_CORRELATION_ID, (String)this.correlationId);
                    }
                    if (this.routeId != null) {
                        MDC.put((String)MDCUnitOfWork.MDC_ROUTE_ID, (String)this.routeId);
                    }
                    if (this.camelContextId != null) {
                        MDC.put((String)MDCUnitOfWork.MDC_CAMEL_CONTEXT_ID, (String)this.camelContextId);
                    }
                }
            }
            finally {
                this.delegate.done(doneSync);
            }
        }

        public String toString() {
            return this.delegate.toString();
        }
    }
}

