/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.model.ExecutorServiceAwareDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.ProcessorDefinitionHelper;
import org.apache.camel.model.WhenDefinition;
import org.apache.camel.processor.CamelInternalProcessor;
import org.apache.camel.processor.OnCompletionProcessor;
import org.apache.camel.spi.RouteContext;

@XmlRootElement(name="onCompletion")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class OnCompletionDefinition
extends ProcessorDefinition<OnCompletionDefinition>
implements ExecutorServiceAwareDefinition<OnCompletionDefinition> {
    @XmlAttribute
    private Boolean onCompleteOnly;
    @XmlAttribute
    private Boolean onFailureOnly;
    @XmlElement(name="onWhen")
    private WhenDefinition onWhen;
    @XmlAttribute
    private String executorServiceRef;
    @XmlAttribute(name="useOriginalMessage")
    private Boolean useOriginalMessagePolicy;
    @XmlElementRef
    private List<ProcessorDefinition<?>> outputs = new ArrayList();
    @XmlTransient
    private ExecutorService executorService;
    @XmlTransient
    private Boolean routeScoped;
    @XmlTransient
    private final Map<String, Processor> onCompletions = new HashMap<String, Processor>();

    public boolean isRouteScoped() {
        return this.routeScoped != null ? this.routeScoped : false;
    }

    public Processor getOnCompletion(String routeId) {
        return this.onCompletions.get(routeId);
    }

    public Collection<Processor> getOnCompletions() {
        return this.onCompletions.values();
    }

    public String toString() {
        return "onCompletion[" + this.getOutputs() + "]";
    }

    @Override
    public String getShortName() {
        return "onCompletion";
    }

    @Override
    public String getLabel() {
        return "onCompletion";
    }

    @Override
    public boolean isAbstract() {
        return true;
    }

    @Override
    public boolean isTopLevelOnly() {
        return true;
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) throws Exception {
        if (this.routeScoped == null) {
            this.routeScoped = super.getParent() != null;
        }
        if (this.isOnCompleteOnly() && this.isOnFailureOnly()) {
            throw new IllegalArgumentException("Both onCompleteOnly and onFailureOnly cannot be true. Only one of them can be true. On node: " + this);
        }
        String routeId = routeContext.getRoute().idOrCreate(routeContext.getCamelContext().getNodeIdFactory());
        Processor childProcessor = this.createChildProcessor(routeContext, true);
        CamelInternalProcessor internal = new CamelInternalProcessor(childProcessor);
        internal.addAdvice(new CamelInternalProcessor.UnitOfWorkProcessorAdvice(routeId));
        internal.addAdvice(new CamelInternalProcessor.RouteContextAdvice(routeContext));
        this.onCompletions.put(routeId, internal);
        Predicate when = null;
        if (this.onWhen != null) {
            when = this.onWhen.getExpression().createPredicate(routeContext);
        }
        boolean shutdownThreadPool = ProcessorDefinitionHelper.willCreateNewThreadPool(routeContext, this, true);
        ExecutorService threadPool = ProcessorDefinitionHelper.getConfiguredExecutorService(routeContext, "OnCompletion", this, true);
        boolean original = this.getUseOriginalMessagePolicy() != null ? this.getUseOriginalMessagePolicy() : false;
        OnCompletionProcessor answer = new OnCompletionProcessor(routeContext.getCamelContext(), internal, threadPool, shutdownThreadPool, this.isOnCompleteOnly(), this.isOnFailureOnly(), when, original);
        return answer;
    }

    public void removeAllOnCompletionDefinition(ProcessorDefinition<?> definition) {
        Iterator<ProcessorDefinition<?>> it = definition.getOutputs().iterator();
        while (it.hasNext()) {
            ProcessorDefinition<?> out = it.next();
            if (!(out instanceof OnCompletionDefinition)) continue;
            it.remove();
        }
    }

    @Override
    public ProcessorDefinition<?> end() {
        this.getParent().popBlock();
        return super.end();
    }

    public OnCompletionDefinition onCompleteOnly() {
        if (this.isOnFailureOnly()) {
            throw new IllegalArgumentException("Both onCompleteOnly and onFailureOnly cannot be true. Only one of them can be true. On node: " + this);
        }
        this.setOnCompleteOnly(Boolean.TRUE);
        this.setOnFailureOnly(Boolean.FALSE);
        return this;
    }

    public OnCompletionDefinition onFailureOnly() {
        if (this.isOnCompleteOnly()) {
            throw new IllegalArgumentException("Both onCompleteOnly and onFailureOnly cannot be true. Only one of them can be true. On node: " + this);
        }
        this.setOnCompleteOnly(Boolean.FALSE);
        this.setOnFailureOnly(Boolean.TRUE);
        return this;
    }

    public OnCompletionDefinition onWhen(Predicate predicate) {
        this.setOnWhen(new WhenDefinition(predicate));
        return this;
    }

    public OnCompletionDefinition useOriginalBody() {
        this.setUseOriginalMessagePolicy(Boolean.TRUE);
        return this;
    }

    @Override
    public OnCompletionDefinition executorService(ExecutorService executorService) {
        this.setExecutorService(executorService);
        return this;
    }

    @Override
    public OnCompletionDefinition executorServiceRef(String executorServiceRef) {
        this.setExecutorServiceRef(executorServiceRef);
        return this;
    }

    @Override
    public List<ProcessorDefinition<?>> getOutputs() {
        return this.outputs;
    }

    public void setOutputs(List<ProcessorDefinition<?>> outputs) {
        this.outputs = outputs;
    }

    @Override
    public boolean isOutputSupported() {
        return true;
    }

    public Boolean getOnCompleteOnly() {
        return this.onCompleteOnly;
    }

    public void setOnCompleteOnly(Boolean onCompleteOnly) {
        this.onCompleteOnly = onCompleteOnly;
    }

    public boolean isOnCompleteOnly() {
        return this.onCompleteOnly != null && this.onCompleteOnly != false;
    }

    public Boolean getOnFailureOnly() {
        return this.onFailureOnly;
    }

    public void setOnFailureOnly(Boolean onFailureOnly) {
        this.onFailureOnly = onFailureOnly;
    }

    public boolean isOnFailureOnly() {
        return this.onFailureOnly != null && this.onFailureOnly != false;
    }

    public WhenDefinition getOnWhen() {
        return this.onWhen;
    }

    public void setOnWhen(WhenDefinition onWhen) {
        this.onWhen = onWhen;
    }

    @Override
    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    @Override
    public String getExecutorServiceRef() {
        return this.executorServiceRef;
    }

    @Override
    public void setExecutorServiceRef(String executorServiceRef) {
        this.executorServiceRef = executorServiceRef;
    }

    public Boolean getUseOriginalMessagePolicy() {
        return this.useOriginalMessagePolicy != null;
    }

    public void setUseOriginalMessagePolicy(Boolean useOriginalMessagePolicy) {
        this.useOriginalMessagePolicy = useOriginalMessagePolicy;
    }
}

