/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.bindy;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.camel.dataformat.bindy.BindyAbstractFactory;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.PackageScanClassResolver;

public abstract class BindyAbstractDataFormat
implements DataFormat {
    private String[] packages;
    private String locale;
    private BindyAbstractFactory modelFactory;
    private Class<?> classType;

    public BindyAbstractDataFormat() {
    }

    public BindyAbstractDataFormat(String ... packages) {
        this.packages = packages;
    }

    protected BindyAbstractDataFormat(Class<?> classType) {
        this.classType = classType;
    }

    public String[] getPackages() {
        return this.packages;
    }

    public void setPackages(String ... packages) {
        this.packages = packages;
    }

    public Class<?> getClassType() {
        return this.classType;
    }

    public void setClassType(Class<?> classType) {
        this.classType = classType;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public BindyAbstractFactory getFactory(PackageScanClassResolver resolver) throws Exception {
        if (this.modelFactory == null) {
            this.modelFactory = this.createModelFactory(resolver);
            this.modelFactory.setLocale(this.locale);
        }
        return this.modelFactory;
    }

    public void setModelFactory(BindyAbstractFactory modelFactory) {
        this.modelFactory = modelFactory;
    }

    protected abstract BindyAbstractFactory createModelFactory(PackageScanClassResolver var1) throws Exception;

    protected Object extractUnmarshalResult(List<Map<String, Object>> models) {
        if (this.getClassType() != null) {
            ArrayList<Object> answer = new ArrayList<Object>();
            for (Map<String, Object> entry : models) {
                Object data = entry.get(this.getClassType().getName());
                if (data == null) continue;
                answer.add(data);
            }
            if (answer.size() == 1) {
                return answer.get(0);
            }
            return answer;
        }
        return models;
    }
}

