/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.rx.support;

import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.rx.support.ProcessorToObserver;
import org.apache.camel.support.ServiceSupport;
import rx.Observable;
import rx.subjects.PublishSubject;
import rx.subjects.Subject;
import rx.util.functions.Func1;

public abstract class ObservableProcessor<T>
extends ServiceSupport
implements Processor {
    private final Subject observable = PublishSubject.create();
    private final ProcessorToObserver processor;

    protected ObservableProcessor(Func1<Exchange, T> func) {
        this.processor = new ProcessorToObserver<T>(func, this.observable);
    }

    public void process(Exchange exchange) throws Exception {
        this.processor.process(exchange);
    }

    public Observable<T> getObservable() {
        return this.observable;
    }

    protected abstract void configure(Observable<T> var1);

    protected void doStart() throws Exception {
        this.configure(this.getObservable());
    }

    protected void doStop() throws Exception {
    }
}

