/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.commands;

import java.io.PrintStream;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.apache.camel.commands.AbstractCamelCommand;
import org.apache.camel.commands.CamelController;
import org.apache.camel.util.CollectionStringBuffer;

public class CatalogLanguageLabelListCommand
extends AbstractCamelCommand {
    private static final String LABEL_COLUMN_LABEL = "Label";
    private static final String NUMBER_COLUMN_LABEL = "#";
    private static final String NAME_COLUMN_LABEL = "Name";
    private static final int DEFAULT_COLUMN_WIDTH_INCREMENT = 0;
    private static final String DEFAULT_FIELD_PREAMBLE = " ";
    private static final String DEFAULT_FIELD_POSTAMBLE = " ";
    private static final String DEFAULT_HEADER_PREAMBLE = " ";
    private static final String DEFAULT_HEADER_POSTAMBLE = " ";
    private static final int DEFAULT_FORMAT_BUFFER_LENGTH = 24;
    private static final int MAX_COLUMN_WIDTH = 120;
    private static final int MIN_COLUMN_WIDTH = 12;
    private static final int MIN_NUMBER_COLUMN_WIDTH = 6;
    private boolean verbose;

    public CatalogLanguageLabelListCommand(boolean verbose) {
        this.verbose = verbose;
    }

    @Override
    public Object execute(CamelController camelController, PrintStream out, PrintStream err) throws Exception {
        Map<String, Set<String>> labels = camelController.listLanguagesLabelCatalog();
        if (labels.isEmpty()) {
            return null;
        }
        Map<String, Integer> columnWidths = this.computeColumnWidths(labels);
        String headerFormat = this.buildFormatString(columnWidths, true);
        String rowFormat = this.buildFormatString(columnWidths, false);
        if (this.verbose) {
            out.println(String.format(headerFormat, LABEL_COLUMN_LABEL, NUMBER_COLUMN_LABEL, NAME_COLUMN_LABEL));
            out.println(String.format(headerFormat, "-----", "-", "----"));
        } else {
            out.println(String.format(headerFormat, LABEL_COLUMN_LABEL));
            out.println(String.format(headerFormat, "-----"));
        }
        for (Map.Entry<String, Set<String>> row : labels.entrySet()) {
            String label;
            if (this.verbose) {
                label = row.getKey();
                String number = "" + row.getValue().size();
                CollectionStringBuffer csb = new CollectionStringBuffer(", ");
                for (String name : row.getValue()) {
                    csb.append((Object)name);
                }
                out.println(String.format(rowFormat, label, number, csb.toString()));
                continue;
            }
            label = row.getKey();
            out.println(String.format(rowFormat, label));
        }
        return null;
    }

    private Map<String, Integer> computeColumnWidths(Map<String, Set<String>> labels) throws Exception {
        if (labels == null) {
            return null;
        }
        int maxLabelLen = LABEL_COLUMN_LABEL.length();
        int maxNameLen = NAME_COLUMN_LABEL.length();
        int counter = 0;
        CollectionStringBuffer csb = new CollectionStringBuffer(", ");
        for (Map.Entry<String, Set<String>> entry : labels.entrySet()) {
            String label = entry.getKey();
            maxLabelLen = Math.max(maxLabelLen, label.length());
            for (String name : entry.getValue()) {
                ++counter;
                csb.append((Object)name);
            }
        }
        maxNameLen = Math.max(maxNameLen, csb.toString().length());
        int maxMumberLen = ("" + counter).length();
        Hashtable<String, Integer> retval = new Hashtable<String, Integer>();
        retval.put(LABEL_COLUMN_LABEL, maxLabelLen);
        retval.put(NUMBER_COLUMN_LABEL, maxMumberLen);
        retval.put(NAME_COLUMN_LABEL, maxNameLen);
        return retval;
    }

    private String buildFormatString(Map<String, Integer> columnWidths, boolean isHeader) {
        String fieldPostamble;
        String fieldPreamble;
        if (isHeader) {
            fieldPreamble = " ";
            fieldPostamble = " ";
        } else {
            fieldPreamble = " ";
            fieldPostamble = " ";
        }
        int columnWidthIncrement = 0;
        if (this.verbose) {
            int labelLen = Math.min(columnWidths.get(LABEL_COLUMN_LABEL) + columnWidthIncrement, this.getMaxColumnWidth(isHeader));
            int numberLen = Math.min(columnWidths.get(NUMBER_COLUMN_LABEL) + columnWidthIncrement, this.getMaxColumnWidth(isHeader));
            labelLen = Math.max(12, labelLen);
            numberLen = Math.max(6, numberLen);
            StringBuilder retval = new StringBuilder(24);
            retval.append(fieldPreamble).append("%-").append(labelLen).append('.').append(labelLen).append('s').append(fieldPostamble).append(' ');
            retval.append(fieldPreamble).append("%-").append(numberLen).append('.').append(numberLen).append('s').append(fieldPostamble).append(' ');
            retval.append(fieldPreamble).append("%s").append(fieldPostamble).append(' ');
            return retval.toString();
        }
        int labelLen = Math.min(columnWidths.get(LABEL_COLUMN_LABEL) + columnWidthIncrement, this.getMaxColumnWidth(isHeader));
        labelLen = Math.max(12, labelLen);
        StringBuilder retval = new StringBuilder(24);
        retval.append(fieldPreamble).append("%-").append(labelLen).append('.').append(labelLen).append('s').append(fieldPostamble).append(' ');
        return retval.toString();
    }

    private int getMaxColumnWidth(boolean isHeader) {
        if (!isHeader && this.verbose) {
            return Integer.MAX_VALUE;
        }
        return 120;
    }
}

