/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sparkrest;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Iterator;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.TypeConverter;
import org.apache.camel.component.sparkrest.SparkBinding;
import org.apache.camel.component.sparkrest.SparkConfiguration;
import org.apache.camel.component.sparkrest.SparkHeaderFilterStrategy;
import org.apache.camel.component.sparkrest.SparkHelper;
import org.apache.camel.component.sparkrest.SparkMessage;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.MessageHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spark.Request;
import spark.Response;

public class DefaultSparkBinding
implements SparkBinding {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultSparkBinding.class);
    private HeaderFilterStrategy headerFilterStrategy = new SparkHeaderFilterStrategy();

    @Override
    public Message toCamelMessage(Request request, Exchange exchange, SparkConfiguration configuration) throws Exception {
        LOG.trace("toCamelMessage: {}", (Object)request);
        SparkMessage answer = new SparkMessage(request, null);
        answer.setExchange(exchange);
        if (configuration.isMapHeaders()) {
            this.populateCamelHeaders(request, answer.getHeaders(), exchange, configuration);
        }
        if (configuration.isDisableStreamCache()) {
            answer.setBody(request.raw().getInputStream());
        } else {
            answer.setBody(request.body());
        }
        return answer;
    }

    @Override
    public void populateCamelHeaders(Request request, Map<String, Object> headers, Exchange exchange, SparkConfiguration configuration) throws Exception {
        String decoded;
        Object value;
        headers.put("CamelHttpMethod", request.raw().getMethod());
        headers.put("CamelHttpQuery", request.raw().getQueryString());
        headers.put("CamelHttpUrl", request.raw().getRequestURL().toString());
        headers.put("CamelHttpUri", request.raw().getRequestURI());
        headers.put("CamelHttpPath", request.raw().getPathInfo());
        headers.put("Content-Type", request.raw().getContentType());
        for (String string : request.attributes()) {
            value = request.attribute(string);
            decoded = this.shouldUrlDecodeHeader(configuration, string, value, "UTF-8");
            if (this.headerFilterStrategy == null || this.headerFilterStrategy.applyFilterToExternalHeaders(string, (Object)decoded, exchange)) continue;
            SparkHelper.appendHeader(headers, string, decoded);
        }
        for (String string : request.headers()) {
            value = request.headers(string);
            decoded = this.shouldUrlDecodeHeader(configuration, string, value, "UTF-8");
            if (this.headerFilterStrategy == null || this.headerFilterStrategy.applyFilterToExternalHeaders(string, (Object)decoded, exchange)) continue;
            SparkHelper.appendHeader(headers, string, decoded);
        }
        for (Map.Entry entry : request.params().entrySet()) {
            String key3 = this.mapKey((String)entry.getKey());
            String value2 = (String)entry.getValue();
            String decoded2 = this.shouldUrlDecodeHeader(configuration, key3, value2, "UTF-8");
            if (this.headerFilterStrategy == null || this.headerFilterStrategy.applyFilterToExternalHeaders(key3, (Object)decoded2, exchange)) continue;
            SparkHelper.appendHeader(headers, key3, decoded2);
        }
        String[] splat = request.splat();
        String string = "splat";
        if (this.headerFilterStrategy != null && !this.headerFilterStrategy.applyFilterToExternalHeaders(string, (Object)splat, exchange)) {
            SparkHelper.appendHeader(headers, string, splat);
        }
    }

    @Override
    public void toSparkResponse(Message message, Response response, SparkConfiguration configuration) throws Exception {
        LOG.trace("toSparkResponse: {}", (Object)message);
        boolean failed = message.getExchange().isFailed();
        int defaultCode = failed ? 500 : 200;
        int code = (Integer)message.getHeader("CamelHttpResponseCode", (Object)defaultCode, Integer.TYPE);
        response.status(code);
        LOG.trace("HTTP Status Code: {}", (Object)code);
        TypeConverter tc = message.getExchange().getContext().getTypeConverter();
        for (Map.Entry entry : message.getHeaders().entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            Iterator it = ObjectHelper.createIterator(value, null);
            while (it.hasNext()) {
                String headerValue = (String)tc.convertTo(String.class, it.next());
                if (headerValue == null || this.headerFilterStrategy == null || this.headerFilterStrategy.applyFilterToCamelHeaders(key, (Object)headerValue, message.getExchange())) continue;
                LOG.trace("HTTP-Header: {}={}", (Object)key, (Object)headerValue);
                response.header(key, headerValue);
            }
        }
        String contentType = MessageHelper.getContentType((Message)message);
        if (contentType != null) {
            response.header("Content-Type", contentType);
            LOG.trace("Content-Type: {}", (Object)contentType);
        }
        Object body = message.getBody();
        Exception cause = message.getExchange().getException();
        if (cause != null) {
            if (configuration.isTransferException()) {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(bos);
                oos.writeObject(cause);
                oos.flush();
                IOHelper.close((Closeable[])new Closeable[]{oos, bos});
                body = bos.toByteArray();
                message.setHeader("Content-Type", (Object)"application/x-java-serialized-object");
            } else {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                cause.printStackTrace(pw);
                body = sw.toString().getBytes();
                message.setHeader("Content-Type", (Object)"text/plain");
            }
            ExchangeHelper.setFailureHandled((Exchange)message.getExchange());
        }
        if (body != null) {
            String str = (String)tc.mandatoryConvertTo(String.class, message.getExchange(), body);
            response.body(str);
            message.setBody((Object)str);
        }
    }

    protected String shouldUrlDecodeHeader(SparkConfiguration configuration, String headerName, Object value, String charset) throws UnsupportedEncodingException {
        if ("Content-Type".equals(headerName)) {
            return value.toString();
        }
        if (configuration.isUrlDecodeHeaders()) {
            return URLDecoder.decode(value.toString(), charset);
        }
        return value.toString();
    }

    protected String mapKey(String key) {
        if (key.startsWith(":")) {
            return key.substring(1);
        }
        return key;
    }
}

