/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jira.consumer;

import com.atlassian.jira.rest.client.domain.BasicIssue;
import com.atlassian.jira.rest.client.domain.Comment;
import com.atlassian.jira.rest.client.domain.Issue;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.jira.JIRAEndpoint;
import org.apache.camel.component.jira.consumer.AbstractJIRAConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewCommentConsumer
extends AbstractJIRAConsumer {
    private static final transient Logger LOG = LoggerFactory.getLogger(NewCommentConsumer.class);
    private List<Long> commentIds = new ArrayList<Long>();

    public NewCommentConsumer(JIRAEndpoint endpoint, Processor processor) {
        super(endpoint, processor);
        LOG.info("JIRA NewCommentConsumer: Indexing current issue comments...");
        this.getComments();
    }

    @Override
    protected int poll() throws Exception {
        Stack<Comment> newComments = this.getComments();
        while (!newComments.empty()) {
            Comment newComment = newComments.pop();
            Exchange e = this.getEndpoint().createExchange();
            e.getIn().setBody((Object)newComment);
            this.getProcessor().process(e);
        }
        return newComments.size();
    }

    private Stack<Comment> getComments() {
        Stack<Comment> newComments = new Stack<Comment>();
        List<BasicIssue> issues = this.getIssues();
        for (BasicIssue issue : issues) {
            Issue fullIssue = this.client().getIssueClient().getIssue(issue.getKey(), null);
            for (Comment comment : fullIssue.getComments()) {
                if (this.commentIds.contains(comment.getId())) continue;
                newComments.push(comment);
                this.commentIds.add(comment.getId());
            }
        }
        return newComments;
    }
}

