/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hazelcast;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.Exchange;

public final class HazelcastComponentHelper {
    private final HashMap<String, Integer> mapping = new HashMap();

    public HazelcastComponentHelper() {
        this.init();
    }

    public static void copyHeaders(Exchange ex) {
        Map headers = ex.getIn().getHeaders();
        if (headers.containsKey("CamelHazelcastObjectId")) {
            headers.remove("CamelHazelcastObjectId");
        }
        if (headers.containsKey("CamelHazelcastOperationType")) {
            headers.remove("CamelHazelcastOperationType");
        }
        if (ex.hasOut()) {
            ex.getOut().setHeaders(headers);
        }
    }

    public static void setListenerHeaders(Exchange ex, String listenerType, String listenerAction, String cacheName) {
        ex.getIn().setHeader("CamelHazelcastCacheName", (Object)cacheName);
        HazelcastComponentHelper.setListenerHeaders(ex, listenerType, listenerAction);
    }

    public static void setListenerHeaders(Exchange ex, String listenerType, String listenerAction) {
        ex.getIn().setHeader("CamelHazelcastListenerAction", (Object)listenerAction);
        ex.getIn().setHeader("CamelHazelcastListenerType", (Object)listenerType);
        ex.getIn().setHeader("CamelHazelcastListenerTime", (Object)new Date().getTime());
    }

    public int lookupOperationNumber(Exchange exchange, int defaultOperation) {
        return this.extractOperationNumber(exchange.getIn().getHeader("CamelHazelcastOperationType"), defaultOperation);
    }

    public int extractOperationNumber(Object value, int defaultOperation) {
        int operation = defaultOperation;
        if (value instanceof String) {
            operation = this.mapToOperationNumber((String)value);
        } else if (value instanceof Integer) {
            operation = (Integer)value;
        }
        return operation;
    }

    private int mapToOperationNumber(String operationName) {
        if (this.mapping.containsKey(operationName)) {
            return this.mapping.get(operationName);
        }
        throw new IllegalArgumentException(String.format("Operation '%s' is not supported by this component.", operationName));
    }

    private void init() {
        this.addMapping("put", 1);
        this.addMapping("delete", 2);
        this.addMapping("get", 3);
        this.addMapping("update", 4);
        this.addMapping("query", 5);
        this.addMapping("removevalue", 10);
        this.addMapping("increment", 20);
        this.addMapping("decrement", 21);
        this.addMapping("setvalue", 22);
        this.addMapping("destroy", 23);
        this.addMapping("add", 31);
        this.addMapping("offer", 32);
        this.addMapping("peek", 33);
        this.addMapping("poll", 34);
        this.addMapping("publish", 35);
    }

    private void addMapping(String operationName, int operationNumber) {
        this.mapping.put(operationName, operationNumber);
        this.mapping.put(String.valueOf(operationNumber), operationNumber);
    }
}

