/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hazelcast.multimap;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.MultiMap;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.component.hazelcast.HazelcastComponentHelper;
import org.apache.camel.component.hazelcast.HazelcastDefaultEndpoint;
import org.apache.camel.component.hazelcast.HazelcastDefaultProducer;

public class HazelcastMultimapProducer
extends HazelcastDefaultProducer {
    private final MultiMap<Object, Object> cache;

    public HazelcastMultimapProducer(HazelcastInstance hazelcastInstance, HazelcastDefaultEndpoint endpoint, String cacheName) {
        super(endpoint);
        this.cache = hazelcastInstance.getMultiMap(cacheName);
    }

    public void process(Exchange exchange) throws Exception {
        Map headers = exchange.getIn().getHeaders();
        Object oid = null;
        if (headers.containsKey("CamelHazelcastObjectId")) {
            oid = headers.get("CamelHazelcastObjectId");
        }
        int operation = this.lookupOperationNumber(exchange);
        switch (operation) {
            case 1: {
                this.put(oid, exchange);
                break;
            }
            case 3: {
                this.get(oid, exchange);
                break;
            }
            case 2: {
                this.delete(oid);
                break;
            }
            case 10: {
                this.removevalue(oid, exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("The value '%s' is not allowed for parameter '%s' on the MULTIMAP cache.", operation, "CamelHazelcastOperationType"));
            }
        }
        HazelcastComponentHelper.copyHeaders(exchange);
    }

    private void put(Object oid, Exchange exchange) {
        Object body = exchange.getIn().getBody();
        this.cache.put(oid, body);
    }

    private void get(Object oid, Exchange exchange) {
        exchange.getOut().setBody((Object)this.cache.get(oid));
    }

    private void delete(Object oid) {
        this.cache.remove(oid);
    }

    private void removevalue(Object oid, Exchange exchange) {
        this.cache.remove(oid, exchange.getIn().getBody());
    }
}

