/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hipchat;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.MapType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.hipchat.HipchatConfiguration;
import org.apache.camel.component.hipchat.HipchatEndpoint;
import org.apache.camel.component.hipchat.HipchatException;
import org.apache.camel.impl.ScheduledPollConsumer;
import org.apache.camel.util.URISupport;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HipchatConsumer
extends ScheduledPollConsumer {
    public static final long DEFAULT_CONSUMER_DELAY = 5000L;
    private static final Logger LOG = LoggerFactory.getLogger(HipchatConsumer.class);
    private static final MapType MAP_TYPE = TypeFactory.defaultInstance().constructMapType(Map.class, String.class, Object.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final CloseableHttpClient HTTP_CLIENT = HttpClients.createDefault();

    public HipchatConsumer(HipchatEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
    }

    protected int poll() throws Exception {
        int messageCount = 0;
        for (String user : this.getConfig().consumableUsers()) {
            Exchange exchange = this.getEndpoint().createExchange();
            this.processExchangeForUser(user, exchange);
            ++messageCount;
        }
        return messageCount;
    }

    private void processExchangeForUser(String user, Exchange exchange) throws Exception {
        String urlPath = String.format(this.getMostRecentMessageUrl(), user);
        LOG.debug("Polling HipChat Api " + urlPath + " for new messages at " + Calendar.getInstance(TimeZone.getTimeZone("UTC")).getTime());
        HttpGet httpGet = new HttpGet(this.getConfig().hipChatUrl() + urlPath);
        CloseableHttpResponse response = this.executeGet(httpGet);
        exchange.getIn().setHeader("HipchatFromUser", (Object)user);
        this.processApiResponse(exchange, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processApiResponse(Exchange exchange, CloseableHttpResponse response) throws Exception {
        block5: {
            try {
                List items;
                Map jsonMap = (Map)MAPPER.readValue(response.getEntity().getContent(), (JavaType)MAP_TYPE);
                LOG.debug("Hipchat response " + response + ", json: " + MAPPER.writeValueAsString((Object)jsonMap));
                if (jsonMap == null || jsonMap.size() <= 0 || (items = (List)jsonMap.get("items")) == null || items.size() <= 0) break block5;
                try {
                    Map item = (Map)items.get(0);
                    String date = (String)item.get("date");
                    String message = (String)item.get("message");
                    LOG.debug("Setting exchange body: " + message + ", header " + "HipchatMessageDate" + ": " + date);
                    exchange.getIn().setHeader("HipchatFromUserResponseStatus", (Object)response.getStatusLine());
                    exchange.getIn().setHeader("HipchatMessageDate", (Object)date);
                    exchange.getIn().setBody((Object)message);
                    this.getProcessor().process(exchange);
                }
                catch (Exception e) {
                    throw new HipchatException("Error parsing Json response from Hipchat API", e);
                }
            }
            finally {
                response.close();
            }
        }
    }

    protected CloseableHttpResponse executeGet(HttpGet httpGet) throws IOException {
        return HTTP_CLIENT.execute((HttpUriRequest)httpGet);
    }

    private String getMostRecentMessageUrl() {
        return this.getConfig().withAuthToken("/v2/user/%s/history/latest") + "&" + "max-results=1";
    }

    private HipchatConfiguration getConfig() {
        return this.getEndpoint().getConfiguration();
    }

    public HipchatEndpoint getEndpoint() {
        return (HipchatEndpoint)super.getEndpoint();
    }

    public String toString() {
        return "HipchatConsumer[" + URISupport.sanitizeUri((String)this.getEndpoint().getEndpointUri()) + "]";
    }
}

