/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hdfs;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.TypeConverter;
import org.apache.camel.component.hdfs.HdfsConfiguration;
import org.apache.camel.component.hdfs.HdfsFileType;
import org.apache.camel.component.hdfs.HdfsInfo;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;

public class HdfsOutputStream
implements Closeable {
    private HdfsFileType fileType;
    private HdfsInfo info;
    private String actualPath;
    private String suffixedPath;
    private Closeable out;
    private volatile boolean opened;
    private final AtomicLong numOfWrittenBytes = new AtomicLong(0L);
    private final AtomicLong numOfWrittenMessages = new AtomicLong(0L);
    private final AtomicLong lastAccess = new AtomicLong(Long.MAX_VALUE);
    private final AtomicBoolean busy = new AtomicBoolean(false);

    protected HdfsOutputStream() {
    }

    public static HdfsOutputStream createOutputStream(String hdfsPath, HdfsConfiguration configuration) throws IOException {
        HdfsOutputStream ret = new HdfsOutputStream();
        ret.fileType = configuration.getFileType();
        ret.actualPath = hdfsPath;
        ret.info = new HdfsInfo(ret.actualPath);
        ret.suffixedPath = ret.actualPath + '.' + configuration.getOpenedSuffix();
        if (configuration.isWantAppend() || configuration.isAppend()) {
            if (!ret.info.getFileSystem().exists(new Path(ret.actualPath))) {
                configuration.setAppend(false);
            } else {
                configuration.setAppend(true);
                ret.info = new HdfsInfo(ret.suffixedPath);
                ret.info.getFileSystem().rename(new Path(ret.actualPath), new Path(ret.suffixedPath));
            }
        } else if (ret.info.getFileSystem().exists(new Path(ret.actualPath))) {
            if (configuration.isOverwrite()) {
                ret.info.getFileSystem().delete(new Path(ret.actualPath), true);
            } else {
                throw new RuntimeCamelException("The file already exists");
            }
        }
        ret.out = ret.fileType.createOutputStream(ret.suffixedPath, configuration);
        ret.opened = true;
        return ret;
    }

    @Override
    public void close() throws IOException {
        if (this.opened) {
            IOUtils.closeStream((Closeable)this.out);
            this.info.getFileSystem().rename(new Path(this.suffixedPath), new Path(this.actualPath));
            this.opened = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(Object key, Object value, TypeConverter typeConverter) {
        try {
            this.busy.set(true);
            long nb = this.fileType.append(this, key, value, typeConverter);
            this.numOfWrittenBytes.addAndGet(nb);
            this.numOfWrittenMessages.incrementAndGet();
            this.lastAccess.set(System.currentTimeMillis());
        }
        finally {
            this.busy.set(false);
        }
    }

    public long getNumOfWrittenBytes() {
        return this.numOfWrittenBytes.longValue();
    }

    public long getNumOfWrittenMessages() {
        return this.numOfWrittenMessages.longValue();
    }

    public long getLastAccess() {
        return this.lastAccess.longValue();
    }

    public String getActualPath() {
        return this.actualPath;
    }

    public AtomicBoolean isBusy() {
        return this.busy;
    }

    public Closeable getOut() {
        return this.out;
    }
}

