/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.redis;

import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.component.redis.RedisConfiguration;
import org.apache.camel.component.redis.RedisEndpoint;
import org.apache.camel.impl.UriEndpointComponent;

public class RedisComponent
extends UriEndpointComponent {
    public RedisComponent() {
        super(RedisEndpoint.class);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        RedisConfiguration configuration = new RedisConfiguration();
        this.setHostAndPort(configuration, remaining);
        this.setProperties(configuration, parameters);
        RedisEndpoint endpoint = new RedisEndpoint(uri, this, configuration);
        return endpoint;
    }

    private void setHostAndPort(RedisConfiguration configuration, String remaining) {
        String[] hostAndPort = remaining.split(":");
        if (hostAndPort.length > 0 && hostAndPort[0].length() > 0) {
            configuration.setHost(hostAndPort[0]);
        }
        if (hostAndPort.length > 1 && hostAndPort[1].length() > 0) {
            configuration.setPort(Integer.parseInt(hostAndPort[1]));
        }
    }
}

